/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.cache2k.Cache;
import org.cache2k.CacheBuilder;
import org.cache2k.CacheSource;

@Immutable
public final class CachingWire
implements Wire {
    private static final CacheSource<Wire, Cache<Query, Response>> FIRST = new CacheSource<Wire, Cache<Query, Response>>(){

        public Cache<Query, Response> get(Wire wire) {
            return CacheBuilder.newCache(Query.class, Response.class).expirySecs((int)TimeUnit.MINUTES.toSeconds(5L)).name(CachingWire.class.getCanonicalName()).source(SECOND).build();
        }
    };
    private static final CacheSource<Query, Response> SECOND = new CacheSource<Query, Response>(){

        public Response get(Query query) throws IOException {
            return query.fetch();
        }
    };
    private static final Cache<Wire, Cache<Query, Response>> CACHE = CacheBuilder.newCache(Wire.class, Cache.class).name(CachingWire.class.getCanonicalName()).source(FIRST).build();
    private final transient Wire origin;
    private final transient String regex;

    public CachingWire(@NotNull(message="wire can't be NULL") Wire wire) {
        this(wire, "$never");
    }

    public CachingWire(@NotNull(message="wire can't be NULL") Wire wire, @NotNull(message="regular expression is NULL") String flsh) {
        this.origin = wire;
        this.regex = flsh;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content) throws IOException {
        URI uri = req.uri().get();
        StringBuilder label = new StringBuilder(100).append(method).append(' ').append(uri.getPath());
        if (uri.getQuery() != null) {
            label.append('?').append(uri.getQuery());
        }
        if (label.toString().matches(this.regex)) {
            ((Cache)CACHE.get((Object)this)).clear();
        }
        Response rsp = method.equals("GET") ? (Response)((Cache)CACHE.get((Object)this)).get((Object)new Query(this.origin, req, home, headers)) : this.origin.send(req, home, method, headers, content);
        return rsp;
    }

    public String toString() {
        return "CachingWire(origin=" + this.origin + ", regex=" + this.regex + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachingWire)) {
            return false;
        }
        CachingWire other = (CachingWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$regex = this.regex;
        String other$regex = other.regex;
        return !(this$regex == null ? other$regex != null : !this$regex.equals(other$regex));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 0 : $origin.hashCode());
        String $regex = this.regex;
        result = result * 59 + ($regex == null ? 0 : $regex.hashCode());
        return result;
    }

    private static final class Query {
        private final transient Wire origin;
        private final transient Request request;
        private final transient String uri;
        private final transient Collection<Map.Entry<String, String>> headers;

        Query(Wire wire, Request req, String home, Collection<Map.Entry<String, String>> hdrs) {
            this.origin = wire;
            this.request = req;
            this.uri = home;
            this.headers = hdrs;
        }

        public Response fetch() throws IOException {
            return this.origin.send(this.request, this.uri, "GET", this.headers, new ByteArrayInputStream(new byte[0]));
        }

        public String toString() {
            return "CachingWire.Query(origin=" + this.origin + ", request=" + this.request + ", uri=" + this.uri + ", headers=" + this.headers + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query other = (Query)o;
            Wire this$origin = this.origin;
            Wire other$origin = other.origin;
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            Request this$request = this.request;
            Request other$request = other.request;
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            String this$uri = this.uri;
            String other$uri = other.uri;
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            Collection<Map.Entry<String, String>> this$headers = this.headers;
            Collection<Map.Entry<String, String>> other$headers = other.headers;
            return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Wire $origin = this.origin;
            result = result * 59 + ($origin == null ? 0 : $origin.hashCode());
            Request $request = this.request;
            result = result * 59 + ($request == null ? 0 : $request.hashCode());
            String $uri = this.uri;
            result = result * 59 + ($uri == null ? 0 : $uri.hashCode());
            Collection<Map.Entry<String, String>> $headers = this.headers;
            result = result * 59 + ($headers == null ? 0 : ((Object)$headers).hashCode());
            return result;
        }
    }
}

