/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonParsingException;
import javax.validation.constraints.NotNull;

@Immutable
public final class JsonResponse
extends AbstractResponse {
    private static final Pattern CONTROL = Pattern.compile("[\u0000-\b\u000e-\u001f\u007f-\uffff]");

    public JsonResponse(@NotNull(message="response can't be NULL") Response resp) {
        super(resp);
    }

    @NotNull(message="JSON response is never NULL")
    public JsonResponse assertJson(@NotNull(message="JSON query can't be NULL") String element) {
        throw new UnsupportedOperationException("assertJson() is not implemented yet, since we are not sure which JSON query standard to use");
    }

    @NotNull(message="JSON reader is never NULL")
    public JsonReader json() {
        String body = this.body();
        return new VerboseReader(Json.createReader((Reader)new StringReader(JsonResponse.escape(body))), body);
    }

    private static String escape(CharSequence input) {
        Matcher matcher = CONTROL.matcher(input);
        StringBuffer escaped = new StringBuffer(input.length());
        while (matcher.find()) {
            matcher.appendReplacement(escaped, String.format("\\\\u%04X", matcher.group().charAt(0)));
        }
        matcher.appendTail(escaped);
        return escaped.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonResponse)) {
            return false;
        }
        JsonResponse other = (JsonResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsonResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    private static final class VerboseReader
    implements JsonReader {
        private final transient JsonReader origin;
        private final transient String json;

        VerboseReader(JsonReader reader, String body) {
            this.origin = reader;
            this.json = body;
        }

        public JsonObject readObject() {
            try {
                return this.origin.readObject();
            }
            catch (JsonParsingException ex) {
                throw new JsonParsingException(this.json, (Throwable)ex, ex.getLocation());
            }
        }

        public JsonArray readArray() {
            try {
                return this.origin.readArray();
            }
            catch (JsonParsingException ex) {
                throw new JsonParsingException(this.json, (Throwable)ex, ex.getLocation());
            }
        }

        public JsonStructure read() {
            try {
                return this.origin.read();
            }
            catch (JsonParsingException ex) {
                throw new JsonParsingException(this.json, (Throwable)ex, ex.getLocation());
            }
        }

        public void close() {
            this.origin.close();
        }
    }
}

