/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import com.jcabi.log.Logger;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@Immutable
public final class RestResponse
extends AbstractResponse {
    public RestResponse(Response resp) {
        super(resp);
    }

    public RestResponse assertThat(Matcher<Response> matcher) {
        MatcherAssert.assertThat((String)String.format("HTTP response is not valid: %s", this), (Object)this, matcher);
        return this;
    }

    public RestResponse assertStatus(int status) {
        String message = String.format("HTTP response with status %d", status);
        MatcherAssert.assertThat((String)String.format("HTTP response status is not equal to %d:%n%s", status, this), (Object)this, (Matcher)new StatusMatch(message, status));
        return this;
    }

    public RestResponse assertStatus(Matcher<Integer> matcher) {
        MatcherAssert.assertThat((String)String.format("HTTP response status is not the one expected:%n%s", this), (Object)this.status(), matcher);
        return this;
    }

    public RestResponse assertBody(Matcher<String> matcher) {
        MatcherAssert.assertThat((String)String.format("HTTP response body content is not valid:%n%s", this), (Object)this.body(), matcher);
        return this;
    }

    public RestResponse assertBinary(Matcher<byte[]> matcher) {
        MatcherAssert.assertThat((String)String.format("HTTP response binary content is not valid:%n%s", this), (Object)this.binary(), matcher);
        return this;
    }

    public RestResponse assertHeader(String name, Matcher<Iterable<String>> matcher) {
        List values = this.headers().get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        MatcherAssert.assertThat((String)String.format("HTTP header '%s' is not valid:%n%s", name, this), values, matcher);
        return this;
    }

    public RestResponse assertHeader(String name, String value) {
        return this.assertHeader(name, (Matcher<Iterable<String>>)Matchers.hasItems((Object[])new String[]{value}));
    }

    public Request jump(URI uri) {
        Request req = this.back().uri().set(this.back().uri().get().resolve(uri)).back();
        Map<String, List<String>> headers = this.headers();
        if (headers.containsKey("Set-Cookie")) {
            for (String header : headers.get("Set-Cookie")) {
                for (HttpCookie cookie : HttpCookie.parse(header)) {
                    req = req.header("Cookie", String.format("%s=%s", cookie.getName(), cookie.getValue()));
                }
            }
        }
        return req;
    }

    public Request follow() {
        this.assertHeader("Location", (Matcher<Iterable<String>>)Matchers.not((Matcher)Matchers.emptyIterableOf(String.class)));
        return this.jump(URI.create(this.headers().get("Location").get(0)));
    }

    public Cookie cookie(String name) {
        Map<String, List<String>> headers = this.headers();
        MatcherAssert.assertThat((String)"cookies should be set in HTTP header", (boolean)headers.containsKey("Set-Cookie"));
        Iterator<String> iterator = headers.get("Set-Cookie").iterator();
        String first = iterator.next();
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append((Object)first);
        }
        while (iterator.hasNext()) {
            buf.append(',');
            String obj = iterator.next();
            if (obj == null) continue;
            buf.append((Object)obj);
        }
        String header = buf.toString();
        Cookie cookie = null;
        for (HttpCookie candidate : HttpCookie.parse(header)) {
            if (!candidate.getName().equals(name)) continue;
            cookie = RestResponse.cookie(candidate);
            break;
        }
        MatcherAssert.assertThat((String)Logger.format((String)"cookie '%s' not found in Set-Cookie header: '%s'", (Object[])new Object[]{name, header}), (Object)cookie, (Matcher)Matchers.notNullValue());
        assert (cookie != null);
        return cookie;
    }

    private static Cookie cookie(HttpCookie cookie) {
        return new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResponse)) {
            return false;
        }
        RestResponse other = (RestResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RestResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    private static final class StatusMatch
    extends CustomMatcher<Response> {
        private final transient int status;

        StatusMatch(String msg, int sts) {
            super(msg);
            this.status = sts;
        }

        public boolean matches(Object resp) {
            return ((Response)Response.class.cast(resp)).status() == this.status;
        }
    }
}

