/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import com.jcabi.log.Logger;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Cookie;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@Immutable
public final class RestResponse
extends AbstractResponse {
    public RestResponse(@NotNull(message="response can't be NULL") Response resp) {
        super(resp);
    }

    @NotNull(message="new response is never NULL")
    public RestResponse assertThat(@NotNull(message="matcher can't be NULL") Matcher<Response> matcher) {
        MatcherAssert.assertThat((String)String.format("HTTP response is not valid: %s", this), (Object)this, matcher);
        return this;
    }

    @NotNull(message="response is never NULL")
    public RestResponse assertStatus(int status) {
        String message = String.format("HTTP response with status %d", status);
        MatcherAssert.assertThat((String)String.format("HTTP response status is not equal to %d:%n%s", status, this), (Object)this, (Matcher)new StatusMatch(message, status));
        return this;
    }

    @NotNull(message="REST response is never NULL")
    public RestResponse assertStatus(@NotNull(message="status matcher can't be NULL") Matcher<Integer> matcher) {
        MatcherAssert.assertThat((String)String.format("HTTP response status is not the one expected:%n%s", this), (Object)this.status(), matcher);
        return this;
    }

    @NotNull(message="REST response is never NULL")
    public RestResponse assertBody(@NotNull(message="body matcher can't be NULL") Matcher<String> matcher) {
        MatcherAssert.assertThat((String)String.format("HTTP response body content is not valid:%n%s", this), (Object)this.body(), matcher);
        return this;
    }

    @NotNull(message="REST response is never NULL")
    public RestResponse assertBinary(@NotNull(message="body matcher can't be NULL") Matcher<byte[]> matcher) {
        MatcherAssert.assertThat((String)String.format("HTTP response binary content is not valid:%n%s", this), (Object)this.binary(), matcher);
        return this;
    }

    @NotNull(message="response is never NULL")
    public RestResponse assertHeader(@NotNull(message="header name can't be NULL") String name, @NotNull(message="header matcher can't be NULL") Matcher<Iterable<String>> matcher) {
        List values = this.headers().get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        MatcherAssert.assertThat((String)String.format("HTTP header '%s' is not valid:%n%s", name, this), values, matcher);
        return this;
    }

    @NotNull(message="response is never NULL")
    public RestResponse assertHeader(@NotNull(message="header name can't be NULL") String name, @NotNull(message="header value can't be NULL") String value) {
        return this.assertHeader(name, (Matcher<Iterable<String>>)Matchers.hasItems((Object[])new String[]{value}));
    }

    @NotNull(message="request is never NULL")
    public Request jump(@NotNull(message="URI can't be NULL") URI uri) {
        Request req = this.back().uri().set(this.back().uri().get().resolve(uri)).back();
        Map<String, List<String>> headers = this.headers();
        if (headers.containsKey("Set-Cookie")) {
            for (String header : headers.get("Set-Cookie")) {
                for (HttpCookie cookie : HttpCookie.parse(header)) {
                    req = req.header("Cookie", String.format("%s=%s", cookie.getName(), cookie.getValue()));
                }
            }
        }
        return req;
    }

    @NotNull(message="request is never NULL")
    public Request follow() {
        this.assertHeader("Location", (Matcher<Iterable<String>>)Matchers.not((Matcher)Matchers.emptyIterableOf(String.class)));
        return this.jump(URI.create(this.headers().get("Location").get(0)));
    }

    @NotNull(message="cookie is never NULL")
    public Cookie cookie(@NotNull String name) {
        Map<String, List<String>> headers = this.headers();
        MatcherAssert.assertThat((String)"cookies should be set in HTTP header", (boolean)headers.containsKey("Set-Cookie"));
        Iterator<String> iterator = headers.get("Set-Cookie").iterator();
        String first = iterator.next();
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append((Object)first);
        }
        while (iterator.hasNext()) {
            buf.append(',');
            String obj = iterator.next();
            if (obj == null) continue;
            buf.append((Object)obj);
        }
        String header = buf.toString();
        Cookie cookie = null;
        for (HttpCookie candidate : HttpCookie.parse(header)) {
            if (!candidate.getName().equals(name)) continue;
            cookie = RestResponse.cookie(candidate);
            break;
        }
        MatcherAssert.assertThat((String)Logger.format((String)"cookie '%s' not found in Set-Cookie header: '%s'", (Object[])new Object[]{name, header}), (Object)cookie, (Matcher)Matchers.notNullValue());
        assert (cookie != null);
        return cookie;
    }

    private static Cookie cookie(HttpCookie cookie) {
        return new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResponse)) {
            return false;
        }
        RestResponse other = (RestResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RestResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    private static final class StatusMatch
    extends CustomMatcher<Response> {
        private final transient int status;

        StatusMatch(String msg, int sts) {
            super(msg);
            this.status = sts;
        }

        public boolean matches(Object resp) {
            return ((Response)Response.class.cast(resp)).status() == this.status;
        }
    }
}

