/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.response;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.response.AbstractResponse;
import com.jcabi.http.response.RestResponse;
import com.jcabi.immutable.ArrayMap;
import com.jcabi.matchers.XhtmlMatchers;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XPathContext;
import java.net.URI;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.xml.namespace.NamespaceContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

@Immutable
public final class XmlResponse
extends AbstractResponse {
    private final transient ArrayMap<String, String> namespaces;

    public XmlResponse(@NotNull(message="response can't be NULL") Response resp) {
        this(resp, (ArrayMap<String, String>)new ArrayMap());
    }

    private XmlResponse(Response resp, ArrayMap<String, String> map) {
        super(resp);
        this.namespaces = map;
    }

    @NotNull(message="XML is never NULL")
    public XML xml() {
        return new XMLDocument(this.body()).merge(this.context());
    }

    @NotNull(message="response is never NULL")
    public XmlResponse registerNs(@NotNull(message="prefix can't be NULL") String prefix, @NotNull(message="URI can't be NULL") String uri) {
        return new XmlResponse(this, (ArrayMap<String, String>)this.namespaces.with((Object)prefix, (Object)uri));
    }

    @NotNull(message="response is never NULL")
    public XmlResponse assertXPath(@NotNull(message="xpath can't be NULL") String xpath) {
        MatcherAssert.assertThat((String)String.format("XML doesn't contain required XPath '%s':%n%s", xpath, this.body()), (Object)this.body(), (Matcher)XhtmlMatchers.hasXPath((String)xpath, (NamespaceContext)this.context()));
        return this;
    }

    @NotNull(message="request is never NULL")
    public Request rel(@NotNull(message="query can't be NULL") String query) {
        this.assertXPath(query);
        return new RestResponse(this).jump(URI.create((String)this.xml().xpath(query).get(0)));
    }

    private NamespaceContext context() {
        XPathContext context = new XPathContext();
        for (Map.Entry entry : this.namespaces.entrySet()) {
            context = context.add((String)entry.getKey(), entry.getValue());
        }
        return context;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XmlResponse)) {
            return false;
        }
        XmlResponse other = (XmlResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof XmlResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

