/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractHeaderBasedCachingWire
implements Wire {
    private final transient Map<Request, Response> cache;
    private final transient Wire origin;
    private final transient String scvh;
    private final transient String cmch;

    AbstractHeaderBasedCachingWire(String scvh, String cmch, Wire wire) {
        this.scvh = scvh;
        this.cmch = cmch;
        this.origin = wire;
        this.cache = new ConcurrentHashMap<Request, Response>();
    }

    @Override
    public final Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        Response rsp = method.equals("GET") && !this.requestHasCmcHeader(headers) ? this.consultCache(req, home, method, headers, content, connect, read) : this.origin.send(req, home, method, headers, content, connect, read);
        return rsp;
    }

    private Response consultCache(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        Response rsp;
        if (this.cache.containsKey(req)) {
            rsp = this.validateCacheWithServer(req, home, method, headers, content, connect, read);
        } else {
            rsp = this.origin.send(req, home, method, headers, content, connect, read);
            this.updateCache(req, rsp);
        }
        return rsp;
    }

    private Response validateCacheWithServer(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        Response cached = this.cache.get(req);
        Collection<Map.Entry<String, String>> hdrs = this.enrich(headers, cached);
        Response result = this.origin.send(req, home, method, hdrs, content, connect, read);
        if (result.status() == 304) {
            result = cached;
        } else {
            this.updateCache(req, result);
        }
        return result;
    }

    private void updateCache(Request req, Response rsp) {
        if (rsp.headers().containsKey(this.scvh)) {
            this.cache.put(req, rsp);
        } else if (rsp.status() == 200) {
            this.cache.remove(req);
        }
    }

    private Collection<Map.Entry<String, String>> enrich(Collection<Map.Entry<String, String>> headers, Response rsp) {
        Collection list = rsp.headers().get(this.scvh);
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(headers.size() + 1);
        for (Map.Entry<String, String> entry : headers) {
            map.put(entry.getKey(), entry.getValue());
        }
        map.put(this.cmch, (String)list.iterator().next());
        return map.entrySet();
    }

    private boolean requestHasCmcHeader(Collection<Map.Entry<String, String>> headers) {
        boolean requestHasCmch = false;
        for (Map.Entry<String, String> header : headers) {
            if (!header.getKey().equals(this.cmch)) continue;
            requestHasCmch = true;
            break;
        }
        return requestHasCmch;
    }
}

