/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.mock.MkQuery;
import com.jcabi.immutable.ArrayMap;
import com.sun.grizzly.tcp.http11.GrizzlyInputStream;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Immutable
final class GrizzlyQuery
implements MkQuery {
    private final transient String mtd;
    @Immutable.Array
    private final transient byte[] content;
    private final transient String home;
    private final transient ArrayMap<String, List<String>> hdrs;

    GrizzlyQuery(GrizzlyRequest request) throws IOException {
        request.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        this.home = GrizzlyQuery.uri(request);
        this.mtd = request.getMethod();
        this.hdrs = GrizzlyQuery.headers(request);
        this.content = GrizzlyQuery.input(request);
    }

    @Override
    public URI uri() {
        return URI.create(this.home);
    }

    @Override
    public String method() {
        return this.mtd;
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.hdrs);
    }

    @Override
    public String body() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] binary() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    private static String uri(GrizzlyRequest request) {
        StringBuilder uri = new StringBuilder(request.getRequestURI());
        String query = request.getQueryString();
        if (query != null && !query.isEmpty()) {
            uri.append('?').append(query);
        }
        return uri.toString();
    }

    private static ArrayMap<String, List<String>> headers(GrizzlyRequest request) {
        ConcurrentHashMap<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>(0);
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            headers.put(ImmutableHeader.normalize(name), GrizzlyQuery.headers(request, name));
        }
        return new ArrayMap(headers);
    }

    private static List<String> headers(GrizzlyRequest request, String name) {
        LinkedList<String> list = new LinkedList<String>();
        Enumeration values = request.getHeaders(name);
        while (values.hasMoreElements()) {
            list.add(values.nextElement().toString());
        }
        return list;
    }

    private static byte[] input(GrizzlyRequest req) throws IOException {
        int bytes;
        byte[] buffer = new byte[8192];
        GrizzlyInputStream input = req.getInputStream();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytes = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytes);
        }
        return output.toByteArray();
    }
}

