/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.request;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.http.Request;
import com.jcabi.http.RequestBody;
import com.jcabi.http.Response;
import com.jcabi.immutable.Array;
import com.jcabi.log.Logger;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Immutable
@Loggable(value=1)
public final class DefaultResponse
implements Response {
    private static final String ERR = "\ufffd";
    private final transient Request req;
    private final transient int code;
    private final transient String phrase;
    private final transient Array<Map.Entry<String, String>> hdrs;
    @Immutable.Array
    private final transient byte[] content;

    public DefaultResponse(Request request, int status, String reason, Array<Map.Entry<String, String>> headers, byte[] body) {
        this.req = request;
        this.code = status;
        this.phrase = reason;
        this.hdrs = headers;
        this.content = (byte[])body.clone();
    }

    @Override
    public Request back() {
        return this.req;
    }

    @Override
    public int status() {
        return this.code;
    }

    @Override
    public String reason() {
        return this.phrase;
    }

    @Override
    public Map<String, List<String>> headers() {
        ConcurrentHashMap<String, List<String>> map = new ConcurrentHashMap<String, List<String>>(0);
        for (Map.Entry header : this.hdrs) {
            map.putIfAbsent((String)header.getKey(), new LinkedList());
            ((List)map.get(header.getKey())).add(header.getValue());
        }
        return map;
    }

    @Override
    public String body() {
        String body = new String(this.content, StandardCharsets.UTF_8);
        if (body.contains(ERR)) {
            throw new IllegalStateException(Logger.format((String)"broken Unicode text at line #%d in '%[text]s' (%d bytes)", (Object[])new Object[]{body.length() - body.replace("\n", "").length(), body, this.content.length}));
        }
        return body;
    }

    @Override
    public byte[] binary() {
        return (byte[])this.content.clone();
    }

    @Override
    public <T extends Response> T as(Class<T> type) {
        try {
            return (T)((Response)type.getDeclaredConstructor(Response.class).newInstance(this));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder(0).append(this.code).append(' ').append(this.phrase).append(" [").append(this.back().uri().get()).append("]\n");
        for (Map.Entry header : this.hdrs) {
            text.append(Logger.format((String)"%s: %s\n", (Object[])new Object[]{header.getKey(), header.getValue()}));
        }
        return text.append('\n').append(new RequestBody.Printable(this.content)).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultResponse)) {
            return false;
        }
        DefaultResponse other = (DefaultResponse)o;
        Request this$req = this.req;
        Request other$req = other.req;
        if (this$req == null ? other$req != null : !this$req.equals(other$req)) {
            return false;
        }
        if (this.code != other.code) {
            return false;
        }
        String this$phrase = this.phrase;
        String other$phrase = other.phrase;
        if (this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase)) {
            return false;
        }
        Array<Map.Entry<String, String>> this$hdrs = this.hdrs;
        Array<Map.Entry<String, String>> other$hdrs = other.hdrs;
        if (this$hdrs == null ? other$hdrs != null : !this$hdrs.equals(other$hdrs)) {
            return false;
        }
        return Arrays.equals(this.content, other.content);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $req = this.req;
        result = result * 59 + ($req == null ? 43 : $req.hashCode());
        result = result * 59 + this.code;
        String $phrase = this.phrase;
        result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
        Array<Map.Entry<String, String>> $hdrs = this.hdrs;
        result = result * 59 + ($hdrs == null ? 43 : $hdrs.hashCode());
        result = result * 59 + Arrays.hashCode(this.content);
        return result;
    }
}

