/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.manifests.Manifests;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

@Immutable
public final class UserAgentWire
implements Wire {
    private final Wire origin;
    private final String agent;

    public UserAgentWire(Wire wire) {
        this(wire, String.format("jcabi-%s/%s Java/%s", Manifests.read((String)"JCabi-Version"), Manifests.read((String)"JCabi-Build"), System.getProperty("java.version")));
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content, int connect, int read) throws IOException {
        LinkedList<Map.Entry<String, String>> hdrs = new LinkedList<Map.Entry<String, String>>();
        boolean absent = true;
        for (Map.Entry<String, String> header : headers) {
            hdrs.add(header);
            if (!header.getKey().equals("User-Agent")) continue;
            absent = false;
        }
        if (absent) {
            hdrs.add(new ImmutableHeader("User-Agent", this.agent));
        }
        return this.origin.send(req, home, method, hdrs, content, connect, read);
    }

    public String toString() {
        return "UserAgentWire(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserAgentWire)) {
            return false;
        }
        UserAgentWire other = (UserAgentWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }

    public UserAgentWire(Wire origin, String agent) {
        this.origin = origin;
        this.agent = agent;
    }
}

