/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.mock;

import com.jcabi.aspects.Loggable;
import com.jcabi.http.mock.MkAnswer;
import com.jcabi.http.mock.MkContainer;
import com.jcabi.http.mock.MkGrizzlyAdapter;
import com.jcabi.http.mock.MkQuery;
import com.jcabi.log.Logger;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsAnything;

@Loggable(value=1)
public final class MkGrizzlyContainer
implements MkContainer {
    private final transient MkGrizzlyAdapter adapter = new MkGrizzlyAdapter();
    private transient GrizzlyWebServer gws;
    private transient int port;

    @Override
    public MkContainer next(MkAnswer answer) {
        return this.next(answer, (Matcher<MkQuery>)new IsAnything());
    }

    @Override
    public MkContainer next(MkAnswer answer, Matcher<MkQuery> condition) {
        return this.next(answer, condition, 1);
    }

    @Override
    public MkContainer next(MkAnswer answer, Matcher<MkQuery> condition, int count) {
        this.adapter.next(answer, condition, count);
        return this;
    }

    @Override
    public MkQuery take() {
        return this.adapter.take();
    }

    @Override
    public MkQuery take(Matcher<MkAnswer> matcher) {
        return this.adapter.take(matcher);
    }

    @Override
    public Collection<MkQuery> takeAll(Matcher<MkAnswer> matcher) {
        return this.adapter.takeAll(matcher);
    }

    @Override
    public int queries() {
        return this.adapter.queries();
    }

    @Override
    public MkContainer start() throws IOException {
        return this.start(MkGrizzlyContainer.reserve());
    }

    @Override
    public MkContainer start(int prt) throws IOException {
        if (this.port != 0) {
            throw new IllegalStateException(String.format("already listening on port %d, use #stop() first", this.port));
        }
        this.port = prt;
        this.gws = new GrizzlyWebServer(this.port);
        this.gws.addGrizzlyAdapter((GrizzlyAdapter)this.adapter, new String[]{"/"});
        this.gws.start();
        Logger.info((Object)this, (String)"started on port #%s", (Object[])new Object[]{prt});
        return this;
    }

    @Override
    public void stop() {
        if (this.gws != null) {
            this.gws.stop();
        }
        Logger.info((Object)this, (String)"stopped on port #%s", (Object[])new Object[]{this.port});
        this.port = 0;
    }

    @Override
    public URI home() {
        return URI.create(String.format("http://localhost:%d/", this.port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int reserve() throws IOException {
        int reserved;
        ServerSocket socket = new ServerSocket(0);
        try {
            reserved = socket.getLocalPort();
        }
        finally {
            socket.close();
        }
        return reserved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkGrizzlyContainer)) {
            return false;
        }
        MkGrizzlyContainer other = (MkGrizzlyContainer)o;
        MkGrizzlyAdapter this$adapter = this.adapter;
        MkGrizzlyAdapter other$adapter = other.adapter;
        if (this$adapter == null ? other$adapter != null : !((Object)((Object)this$adapter)).equals((Object)other$adapter)) {
            return false;
        }
        GrizzlyWebServer this$gws = this.gws;
        GrizzlyWebServer other$gws = other.gws;
        if (this$gws == null ? other$gws != null : !this$gws.equals(other$gws)) {
            return false;
        }
        return this.port == other.port;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkGrizzlyAdapter $adapter = this.adapter;
        result = result * 59 + ($adapter == null ? 0 : ((Object)((Object)$adapter)).hashCode());
        GrizzlyWebServer $gws = this.gws;
        result = result * 59 + ($gws == null ? 0 : $gws.hashCode());
        result = result * 59 + this.port;
        return result;
    }
}

