/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.request;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import java.util.Arrays;

@Immutable
@Loggable(value=1)
public final class MultipartBodyBuilder {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final transient byte[] values;

    public MultipartBodyBuilder() {
        this(new byte[0]);
    }

    public MultipartBodyBuilder(byte[] values) {
        this.values = (byte[])values.clone();
    }

    public MultipartBodyBuilder appendLine(byte[] bytes) {
        return this.append(bytes).append(CRLF);
    }

    public byte[] asBytes() {
        return (byte[])this.values.clone();
    }

    public MultipartBodyBuilder append(byte[] bytes) {
        int offset = this.values.length;
        byte[] neww = Arrays.copyOf(this.values, offset + bytes.length);
        System.arraycopy(bytes, 0, neww, offset, bytes.length);
        return new MultipartBodyBuilder(neww);
    }
}

