/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.jdbc.ColumnOutcome$AjcClosure1;
import com.jcabi.jdbc.Outcome;
import com.jcabi.jdbc.Utc;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Immutable
public final class ColumnOutcome<T>
implements Outcome<Collection<T>> {
    private final transient String type;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ColumnOutcome(@NotNull(message="type can't be NULL") Class<T> tpe) {
        block4: {
            Class<T> clazz = tpe;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, clazz);
            MethodValidator.aspectOf().beforeCtor(joinPoint);
            Class<T> clazz2 = tpe;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, clazz2);
            try {
                if (tpe.equals(String.class) || tpe.equals(Long.class) || tpe.equals(Boolean.class) || tpe.equals(Byte.class) || tpe.equals(Date.class) || tpe.equals(Utc.class) || byte[].class.equals(tpe)) {
                    this.type = tpe.getName();
                    break block4;
                }
                throw new IllegalArgumentException(String.format("type %s is not supported", tpe.getName()));
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint2);
            }
        }
    }

    @Override
    @Loggable(value=1)
    public Collection<T> handle(ResultSet rset, Statement stmt) throws SQLException {
        ResultSet resultSet = rset;
        Statement statement = stmt;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)resultSet, (Object)statement);
        Object[] objectArray = new Object[]{this, resultSet, statement, joinPoint};
        return (Collection)MethodLogger.aspectOf().wrapMethod(new ColumnOutcome$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private T fetch(ResultSet rset) throws SQLException {
        Object result;
        Class<?> tpe;
        block9: {
            try {
                tpe = Class.forName(this.type);
                if (tpe.equals(String.class)) {
                    result = rset.getString(1);
                    break block9;
                }
                if (tpe.equals(Long.class)) {
                    result = rset.getLong(1);
                    break block9;
                }
                if (tpe.equals(Boolean.class)) {
                    result = rset.getBoolean(1);
                    break block9;
                }
                if (tpe.equals(Byte.class)) {
                    result = rset.getByte(1);
                    break block9;
                }
                if (tpe.equals(Date.class)) {
                    result = rset.getDate(1);
                    break block9;
                }
                if (tpe.equals(Utc.class)) {
                    result = new Utc(Utc.getTimestamp(rset, 1));
                    break block9;
                }
                if (byte[].class.equals(tpe)) {
                    result = rset.getBytes(1);
                    break block9;
                }
                throw new IllegalStateException(String.format("type %s is not allowed", tpe.getName()));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(String.format("Unknown type: %s", this.type), ex);
            }
        }
        return (T)tpe.cast(result);
    }

    public String toString() {
        return "ColumnOutcome(type=" + this.type + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnOutcome)) {
            return false;
        }
        ColumnOutcome other = (ColumnOutcome)o;
        String this$type = this.type;
        String other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        return result;
    }

    static {
        ColumnOutcome.ajc$preClinit();
    }

    static /* synthetic */ Collection handle_aroundBody0(ColumnOutcome ajc$this, ResultSet rset, Statement stmt, JoinPoint joinPoint) {
        LinkedList result = new LinkedList();
        while (rset.next()) {
            result.add(ajc$this.fetch(rset));
        }
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ColumnOutcome.java", ColumnOutcome.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handle", "com.jcabi.jdbc.ColumnOutcome", "java.sql.ResultSet:java.sql.Statement", "rset:stmt", "java.sql.SQLException", "java.util.Collection"), 94);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.jdbc.ColumnOutcome", "java.lang.Class", "tpe", ""), 77);
        ajc$tjp_2 = factory.makeSJP("preinitialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.jdbc.ColumnOutcome", "java.lang.Class", "tpe", ""), 75);
    }
}

