/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.jdbc.Outcome;
import com.jcabi.jdbc.Utc;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DefaultMappings
implements Outcome.Mappings {
    private final Map<Class<?>, Outcome.Mapping<?>> map;

    DefaultMappings() {
        this(1);
    }

    DefaultMappings(int column) {
        this(new AbstractMap.SimpleImmutableEntry<Class<String>, Outcome.Mapping<Object>>(String.class, rs -> rs.getString(column)), new AbstractMap.SimpleImmutableEntry<Class<Long>, Outcome.Mapping<Object>>(Long.class, rs -> rs.getLong(column)), new AbstractMap.SimpleImmutableEntry<Class<Boolean>, Outcome.Mapping<Object>>(Boolean.class, rs -> rs.getBoolean(column)), new AbstractMap.SimpleImmutableEntry<Class<Byte>, Outcome.Mapping<Object>>(Byte.class, rs -> rs.getByte(column)), new AbstractMap.SimpleImmutableEntry<Class<Date>, Outcome.Mapping<Object>>(Date.class, rs -> rs.getDate(column)), new AbstractMap.SimpleImmutableEntry<Class<Utc>, Outcome.Mapping<Object>>(Utc.class, rs -> new Utc(Utc.getTimestamp(rs, column))), new AbstractMap.SimpleImmutableEntry<Class<byte[]>, Outcome.Mapping<Object>>(byte[].class, rs -> rs.getBytes(column)), new AbstractMap.SimpleImmutableEntry<Class<BigDecimal>, Outcome.Mapping<Object>>(BigDecimal.class, rs -> rs.getBigDecimal(column)), new AbstractMap.SimpleImmutableEntry<Class<UUID>, Outcome.Mapping<Object>>(UUID.class, rs -> rs.getObject(column, UUID.class)));
    }

    @SafeVarargs
    private DefaultMappings(Map.Entry<Class<?>, Outcome.Mapping<?>> ... mappings) {
        this(Stream.of(mappings).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public <X> Outcome.Mapping<X> forType(Class<? extends X> tpe) {
        if (!this.map.containsKey(tpe)) {
            throw new IllegalArgumentException(String.format("Type %s is not supported", tpe.getName()));
        }
        return this.map.get(tpe);
    }

    private DefaultMappings(Map<Class<?>, Outcome.Mapping<?>> map) {
        this.map = map;
    }
}

