/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.jdbc.Connect;
import com.jcabi.jdbc.Outcome;
import com.jcabi.jdbc.Preparation;
import com.jcabi.jdbc.PrepareArgs;
import com.jcabi.jdbc.Request;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;

public final class JdbcSession {
    private final transient DataSource source;
    private final transient Collection<Object> args = new LinkedList<Object>();
    private final transient Collection<Preparation> preparations = new LinkedList<Preparation>();
    private final transient AtomicReference<Connection> connection = new AtomicReference();
    private transient boolean auto = true;
    private transient String query;

    public JdbcSession(DataSource src) {
        this.source = src;
        this.preparations.add(new PrepareArgs(this.args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSession sql(String sql) {
        Collection<Object> collection = this.args;
        synchronized (collection) {
            this.query = sql;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSession autocommit(boolean autocommit) {
        Collection<Object> collection = this.args;
        synchronized (collection) {
            this.auto = autocommit;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSession set(Object value) {
        Collection<Object> collection = this.args;
        synchronized (collection) {
            this.args.add(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSession prepare(Preparation prp) {
        Collection<Object> collection = this.args;
        synchronized (collection) {
            this.preparations.add(prp);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcSession clear() {
        Collection<Object> collection = this.args;
        synchronized (collection) {
            this.args.clear();
            this.preparations.clear();
            this.preparations.add(new PrepareArgs(this.args));
        }
        return this;
    }

    public void commit() throws SQLException {
        Connection conn = this.connection.get();
        if (conn == null) {
            throw new IllegalStateException("Connection is not open, can't commit");
        }
        conn.commit();
        this.disconnect();
    }

    public void rollback() throws SQLException {
        Connection conn = this.connection.get();
        if (conn == null) {
            throw new IllegalStateException("Connection is not open, can't rollback");
        }
        conn.rollback();
        this.disconnect();
    }

    public <T> T insert(Outcome<T> outcome) throws SQLException {
        return this.run(outcome, new Connect.WithKeys(this.query), Request.EXECUTE);
    }

    public <T> T update(Outcome<T> outcome) throws SQLException {
        return this.run(outcome, new Connect.WithKeys(this.query), Request.EXECUTE_UPDATE);
    }

    public <T> T call(Outcome<T> outcome) throws SQLException {
        return this.run(outcome, new Connect.Call(this.query), Request.EXECUTE_UPDATE);
    }

    public JdbcSession execute() throws SQLException {
        String vendor;
        try (Connection conn = this.source.getConnection();){
            vendor = conn.getMetaData().getDatabaseProductName();
        }
        Connect connect = vendor.equalsIgnoreCase("mysql") ? new Connect.WithKeys(this.query) : new Connect.Plain(this.query);
        this.run(Outcome.VOID, connect, Request.EXECUTE);
        return this;
    }

    public <T> T select(Outcome<T> outcome) throws SQLException {
        return this.run(outcome, new Connect.Plain(this.query), Request.EXECUTE_QUERY);
    }

    private <T> T run(Outcome<T> outcome, Connect connect, Request request) throws SQLException {
        if (this.query == null) {
            throw new IllegalStateException("Call #sql() first");
        }
        Connection conn = this.connect();
        conn.setAutoCommit(this.auto);
        try {
            T t = this.fetch(outcome, request, connect.open(conn));
            return t;
        }
        catch (SQLException ex) {
            this.rollbackOnFailure(conn, ex);
            throw new SQLException(ex);
        }
        finally {
            if (this.auto) {
                this.disconnect();
            }
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T fetch(Outcome<T> outcome, Request request, PreparedStatement stmt) throws SQLException {
        T result;
        try {
            this.configure(stmt);
            try (ResultSet rset = request.fetch(stmt);){
                result = outcome.handle(rset, stmt);
            }
        }
        finally {
            stmt.close();
        }
        return result;
    }

    private void rollbackOnFailure(Connection conn, SQLException failure) throws SQLException {
        if (!this.auto) {
            try {
                conn.rollback();
                this.disconnect();
            }
            catch (SQLException exc) {
                throw new SQLException(String.format("Failed to rollback after failure: %s", exc.getMessage()), failure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection connect() throws SQLException {
        Collection<Object> collection = this.args;
        synchronized (collection) {
            if (this.connection.get() == null) {
                this.connection.set(this.source.getConnection());
            }
            return this.connection.get();
        }
    }

    private void disconnect() throws SQLException {
        Connection conn = this.connection.getAndSet(null);
        if (conn == null) {
            throw new IllegalStateException("Connection is not open, can't close");
        }
        conn.close();
    }

    private void configure(PreparedStatement stmt) throws SQLException {
        for (Preparation prep : this.preparations) {
            prep.prepare(stmt);
        }
    }

    public String toString() {
        return "JdbcSession(source=" + this.source + ", args=" + this.args + ", preparations=" + this.preparations + ", connection=" + this.connection + ", auto=" + this.auto + ", query=" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSession)) {
            return false;
        }
        JdbcSession other = (JdbcSession)o;
        if (this.auto != other.auto) {
            return false;
        }
        DataSource this$source = this.source;
        DataSource other$source = other.source;
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Collection<Object> this$args = this.args;
        Collection<Object> other$args = other.args;
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        AtomicReference<Connection> this$connection = this.connection;
        AtomicReference<Connection> other$connection = other.connection;
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
            return false;
        }
        String this$query = this.query;
        String other$query = other.query;
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.auto ? 79 : 97);
        DataSource $source = this.source;
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Collection<Object> $args = this.args;
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        AtomicReference<Connection> $connection = this.connection;
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        String $query = this.query;
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }
}

