/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.jdbc.Outcome;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class SingleOutcome<T>
implements Outcome<T> {
    private final Outcome.Mapping<? extends T> mapping;
    private final boolean silently;

    public SingleOutcome(Class<T> tpe) {
        this(tpe, false);
    }

    public SingleOutcome(Class<T> tpe, boolean slnt) {
        this(tpe, Outcome.DEFAULT_MAPPINGS, slnt);
    }

    public SingleOutcome(Class<T> tpe, Outcome.Mappings mps, boolean slnt) {
        this(mps.forType(tpe), slnt);
    }

    @Override
    public T handle(ResultSet rset, Statement stmt) throws SQLException {
        T result = null;
        if (rset.next()) {
            result = this.fetch(rset);
        } else if (!this.silently) {
            throw new SQLException("No records found");
        }
        return result;
    }

    private T fetch(ResultSet rset) throws SQLException {
        return this.mapping.map(rset);
    }

    public String toString() {
        return "SingleOutcome(mapping=" + this.mapping + ", silently=" + this.silently + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleOutcome)) {
            return false;
        }
        SingleOutcome other = (SingleOutcome)o;
        if (this.silently != other.silently) {
            return false;
        }
        Outcome.Mapping<T> this$mapping = this.mapping;
        Outcome.Mapping<? extends T> other$mapping = other.mapping;
        return !(this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.silently ? 79 : 97);
        Outcome.Mapping<T> $mapping = this.mapping;
        result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
        return result;
    }

    public SingleOutcome(Outcome.Mapping<? extends T> mapping, boolean silently) {
        this.mapping = mapping;
        this.silently = silently;
    }
}

