/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.jdbc.Outcome;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public final class StoredProcedureOutcome<T>
implements Outcome<T> {
    private final transient int[] indexes;

    public StoredProcedureOutcome(int ... indexes) {
        if (indexes.length == 0) {
            throw new IllegalArgumentException("At least one OUT param's index needs to be specified");
        }
        int size = indexes.length;
        this.indexes = new int[size];
        for (int idx = 0; idx < size; ++idx) {
            this.indexes[idx] = indexes[idx];
        }
    }

    @Override
    public T handle(ResultSet rset, Statement stmt) throws SQLException {
        int params = this.indexes.length;
        Object[] outs = new Object[params];
        if (stmt instanceof CallableStatement) {
            for (int idx = 0; idx < params; ++idx) {
                outs[idx] = ((CallableStatement)stmt).getObject(this.indexes[idx]);
            }
        }
        return (T)outs;
    }

    public String toString() {
        return "StoredProcedureOutcome(indexes=" + Arrays.toString(this.indexes) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof StoredProcedureOutcome;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

