/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;

public final class Utc {
    private static final Calendar CALENDAR = Calendar.getInstance(new SimpleTimeZone(0, "UTC"));
    private final transient long date;

    public Utc() {
        this(new Date());
    }

    public Utc(Date when) {
        this.date = when.getTime();
    }

    public Date getDate() {
        return new Date(this.date);
    }

    public void setTimestamp(PreparedStatement stmt, int pos) throws SQLException {
        stmt.setTimestamp(pos, new Timestamp(this.date), CALENDAR);
    }

    public static Date getTimestamp(ResultSet rset, int pos) throws SQLException {
        Timestamp stamp = rset.getTimestamp(pos, CALENDAR);
        Date when = null;
        if (stamp != null) {
            when = new Date(stamp.getTime());
        }
        return when;
    }

    public String toString() {
        return "Utc(date=" + this.getDate() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Utc)) {
            return false;
        }
        Utc other = (Utc)o;
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }
}

