/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.log.PreFormatter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.LoggerFactory;

@Immutable
public final class Logger {
    private static final Object[] EMPTY;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    private Logger() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    public static String format(String fmt, Object ... args) {
        String result;
        if (args.length == 0) {
            result = fmt;
        } else {
            PreFormatter pre = new PreFormatter(fmt, args);
            result = String.format(pre.getFormat(), pre.getArguments());
        }
        return result;
    }

    public static void trace(Object source, String msg) {
        Logger.trace(source, msg, EMPTY);
    }

    public static void trace(Object source, String msg, Object ... args) {
        if (Logger.isTraceEnabled(source)) {
            Logger.logger(source).trace(Logger.format(msg, args));
        }
    }

    public static void debug(Object source, String msg) {
        Logger.debug(source, msg, EMPTY);
    }

    public static void debug(Object source, String msg, Object ... args) {
        if (Logger.isDebugEnabled(source)) {
            Logger.logger(source).debug(Logger.format(msg, args));
        }
    }

    public static void info(Object source, String msg) {
        Logger.info(source, msg, EMPTY);
    }

    public static void info(Object source, String msg, Object ... args) {
        if (Logger.isInfoEnabled(source)) {
            Logger.logger(source).info(Logger.format(msg, args));
        }
    }

    public static void warn(Object source, String msg) {
        Logger.warn(source, msg, EMPTY);
    }

    public static void warn(Object source, String msg, Object ... args) {
        if (Logger.isWarnEnabled(source)) {
            Logger.logger(source).warn(Logger.format(msg, args));
        }
    }

    public static void error(Object source, String msg) {
        Logger.error(source, msg, EMPTY);
    }

    public static void error(Object source, String msg, Object ... args) {
        Logger.logger(source).error(Logger.format(msg, args));
    }

    public static boolean isTraceEnabled(Object source) {
        return Logger.logger(source).isTraceEnabled();
    }

    public static boolean isDebugEnabled(Object source) {
        return Logger.logger(source).isDebugEnabled();
    }

    public static boolean isInfoEnabled(Object source) {
        return Logger.logger(source).isInfoEnabled();
    }

    public static boolean isWarnEnabled(Object source) {
        return Logger.logger(source).isWarnEnabled();
    }

    public static boolean isEnabled(Level level, Object source) {
        boolean enabled = false;
        if (level.equals(Level.SEVERE)) {
            enabled = Logger.logger(source).isErrorEnabled();
        } else if (level.equals(Level.WARNING)) {
            enabled = Logger.logger(source).isWarnEnabled();
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            enabled = Logger.logger(source).isInfoEnabled();
        } else if (level.equals(Level.FINE) || level.equals(Level.ALL)) {
            enabled = Logger.logger(source).isDebugEnabled();
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            enabled = Logger.logger(source).isTraceEnabled();
        }
        return enabled;
    }

    public static void log(Level level, Object source, String msg, Object ... args) {
        if (level.equals(Level.SEVERE)) {
            Logger.error(source, msg, args);
        } else if (level.equals(Level.WARNING)) {
            Logger.warn(source, msg, args);
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            Logger.info(source, msg, args);
        } else if (level.equals(Level.FINE) || level.equals(Level.ALL)) {
            Logger.debug(source, msg, args);
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            Logger.trace(source, msg, args);
        }
    }

    public static OutputStream stream(final Level level, final Object source) {
        return new OutputStream(){
            private final transient ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public void write(int data) throws IOException {
                if (data == 10) {
                    Logger.log(level, source, this.buffer.toString("UTF-8"), new Object[0]);
                    this.buffer.reset();
                } else {
                    this.buffer.write(data);
                }
            }
        };
    }

    private static org.slf4j.Logger logger(Object source) {
        org.slf4j.Logger logger = source instanceof Class ? LoggerFactory.getLogger((Class)((Class)source)) : LoggerFactory.getLogger(source.getClass());
        return logger;
    }

    public String toString() {
        return "Logger()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Logger;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static {
        Logger.ajc$preClinit();
        EMPTY = new Object[0];
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Logger.java", Logger.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.jcabi.log.Logger", "", "", ""), 105);
    }
}

