/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public final class VerboseProcess {
    private final transient Process process;
    private final transient Level olevel;
    private final transient Level elevel;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    /*
     * WARNING - void declaration
     */
    public VerboseProcess(Process prc) {
        void stderr;
        void stdout;
        Level level = Level.WARNING;
        Level level2 = Level.INFO;
        Process prc2 = prc;
        VerboseProcess ajc$aspectInstance = this;
        ajc$aspectInstance.process = prc2;
        ajc$aspectInstance.olevel = stdout;
        ajc$aspectInstance.elevel = stderr;
    }

    /*
     * WARNING - void declaration
     */
    public VerboseProcess(@NotNull(message="process builder can't be NULL") ProcessBuilder builder) {
        void stderr;
        void stdout;
        void prc;
        Process prc2 = VerboseProcess.start(builder);
        VerboseProcess ajc$aspectInstance = this;
        Level level = Level.WARNING;
        Level level2 = Level.INFO;
        Process process = prc2;
        VerboseProcess ajc$aspectInstance2 = ajc$aspectInstance;
        ProcessBuilder processBuilder = builder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)processBuilder);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        ajc$aspectInstance2.process = prc;
        ajc$aspectInstance2.olevel = stdout;
        ajc$aspectInstance2.elevel = stderr;
    }

    public VerboseProcess(@NotNull(message="process can't be NULL") Process prc, @NotNull(message="stdout level can't be NULL") Level stdout, @NotNull(message="stderr level can't be NULL") Level stderr) {
        Process process = prc;
        Level level = stdout;
        Level level2 = stderr;
        Object[] objectArray = new Object[]{process, level, level2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        this.process = prc;
        this.olevel = stdout;
        this.elevel = stderr;
    }

    /*
     * WARNING - void declaration
     */
    public VerboseProcess(@NotNull(message="process can't be NULL") ProcessBuilder bdr, @NotNull(message="stdout level can't be NULL") Level stdout, @NotNull(message="stderr level can't be NULL") Level stderr) {
        void stderr2;
        void stdout2;
        void prc;
        Level level = stderr;
        Level level2 = stdout;
        Process process = VerboseProcess.start(bdr);
        VerboseProcess ajc$aspectInstance = this;
        ProcessBuilder processBuilder = bdr;
        Level level3 = stdout;
        Level level4 = stderr;
        Object[] objectArray = new Object[]{processBuilder, level3, level4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        ajc$aspectInstance.process = prc;
        ajc$aspectInstance.olevel = stdout2;
        ajc$aspectInstance.elevel = stderr2;
    }

    public String stdout() {
        return this.stdout(true);
    }

    public String stdoutQuietly() {
        return this.stdout(false);
    }

    private static Process start(@NotNull ProcessBuilder builder) {
        ProcessBuilder processBuilder = builder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)processBuilder);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            return process;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String stdout(boolean check) {
        String stdout;
        long start = System.currentTimeMillis();
        try {
            stdout = this.waitFor();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        int code = this.process.exitValue();
        Logger.debug(this, "#stdout(): process %s completed (code=%d, size=%d) in %[ms]s", this.process, code, stdout.length(), System.currentTimeMillis() - start);
        if (check && code != 0) {
            throw new IllegalArgumentException(Logger.format("Non-zero exit code %d: %[text]s", code, stdout));
        }
        return stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitFor() throws InterruptedException {
        CountDownLatch done = new CountDownLatch(2);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        Logger.debug(this, "#waitFor(): waiting for stdout of %s in %s...", this.process, this.monitor(this.process.getInputStream(), done, stdout, this.olevel));
        Logger.debug(this, "#waitFor(): waiting for stderr of %s in %s...", this.process, this.monitor(this.process.getErrorStream(), done, new ByteArrayOutputStream(), this.elevel));
        try {
            this.process.waitFor();
        }
        catch (Throwable throwable) {
            Logger.debug(this, "#waitFor(): process finished : %s", this.process);
            if (!done.await(2L, TimeUnit.SECONDS)) {
                Logger.error(this, "#wait() failed");
            }
            throw throwable;
        }
        Logger.debug(this, "#waitFor(): process finished : %s", this.process);
        if (!done.await(2L, TimeUnit.SECONDS)) {
            Logger.error(this, "#wait() failed");
        }
        try {
            return stdout.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Thread monitor(InputStream input, CountDownLatch done, OutputStream output, Level level) {
        Thread thread = new Thread(new VerboseRunnable(new Monitor(input, done, output, level), false));
        thread.setName("VerboseProcess");
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public String toString() {
        return "VerboseProcess(process=" + this.process + ", olevel=" + this.olevel + ", elevel=" + this.elevel + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerboseProcess)) {
            return false;
        }
        VerboseProcess other = (VerboseProcess)o;
        Process this$process = this.process;
        Process other$process = other.process;
        return !(this$process == null ? other$process != null : !this$process.equals(other$process));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Process $process = this.process;
        result = result * 59 + ($process == null ? 0 : $process.hashCode());
        return result;
    }

    static {
        VerboseProcess.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("VerboseProcess.java", VerboseProcess.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "start", "com.jcabi.log.VerboseProcess", "java.lang.ProcessBuilder", "builder", "", "java.lang.Process"), 180);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.log.VerboseProcess", "java.lang.ProcessBuilder", "builder", ""), 120);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.log.VerboseProcess", "java.lang.Process:java.util.logging.Level:java.util.logging.Level", "prc:stdout:stderr", ""), 120);
        ajc$tjp_3 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.log.VerboseProcess", "java.lang.ProcessBuilder:java.util.logging.Level:java.util.logging.Level", "bdr:stdout:stderr", ""), 120);
    }

    private static final class Monitor
    implements Callable<Void> {
        private final transient InputStream input;
        private final transient CountDownLatch done;
        private final transient OutputStream output;
        private final transient Level level;

        Monitor(InputStream inp, CountDownLatch latch, OutputStream out, Level lvl) {
            this.input = inp;
            this.done = latch;
            this.output = out;
            this.level = lvl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.input, Charset.forName("UTF-8")));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.output, Charset.forName("UTF-8")));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Logger.log(this.level, VerboseProcess.class, ">> %s", line);
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException ex) {
                    Logger.error(this, "failed to close reader: %[exception]s", ex);
                }
                this.done.countDown();
                throw throwable;
            }
            try {
                reader.close();
                writer.close();
            }
            catch (IOException ex) {
                Logger.error(this, "failed to close reader: %[exception]s", ex);
            }
            this.done.countDown();
            return null;
        }
    }
}

