/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Logger;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class VerboseThreads
implements ThreadFactory {
    private final transient ThreadGroup group;
    private final transient String prefix;
    private final transient AtomicInteger number = new AtomicInteger(1);
    private final transient boolean daemon;
    private final transient int priority;

    public VerboseThreads() {
        this("verbose", true, 1);
    }

    public VerboseThreads(String pfx) {
        this(pfx, true, 1);
    }

    public VerboseThreads(Object type) {
        this(type.getClass().getSimpleName(), true, 1);
    }

    public VerboseThreads(Class<?> type) {
        this(type.getSimpleName(), true, 1);
    }

    public VerboseThreads(String pfx, boolean dmn, int prt) {
        this.prefix = pfx;
        this.daemon = dmn;
        this.priority = prt;
        this.group = new Group(pfx);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, new Wrap(runnable));
        thread.setName(String.format("%s-%d", this.prefix, this.number.getAndIncrement()));
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        return thread;
    }

    public String toString() {
        return "VerboseThreads(group=" + this.group + ", prefix=" + this.prefix + ", number=" + this.number + ", daemon=" + this.daemon + ", priority=" + this.priority + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerboseThreads)) {
            return false;
        }
        VerboseThreads other = (VerboseThreads)o;
        ThreadGroup this$group = this.group;
        ThreadGroup other$group = other.group;
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$prefix = this.prefix;
        String other$prefix = other.prefix;
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        AtomicInteger this$number = this.number;
        AtomicInteger other$number = other.number;
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        if (this.daemon != other.daemon) {
            return false;
        }
        return this.priority == other.priority;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThreadGroup $group = this.group;
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $prefix = this.prefix;
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        AtomicInteger $number = this.number;
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        result = result * 59 + (this.daemon ? 79 : 97);
        result = result * 59 + this.priority;
        return result;
    }

    private static final class Wrap
    implements Runnable {
        private final transient Runnable origin;

        Wrap(Runnable runnable) {
            this.origin = runnable;
        }

        @Override
        public void run() {
            try {
                this.origin.run();
            }
            catch (RuntimeException ex) {
                Logger.warn(this, "%s: %[exception]s", Thread.currentThread().getName(), ex);
                throw ex;
            }
            catch (Error error) {
                Logger.error(this, "%s (error): %[exception]s", Thread.currentThread().getName(), error);
                throw error;
            }
        }
    }

    private static final class Group
    extends ThreadGroup {
        Group(String name) {
            super(name);
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            Logger.warn(this, "%[exception]s", throwable);
        }
    }
}

