/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Logger;
import java.util.concurrent.Callable;

public final class VerboseRunnable
implements Runnable {
    private final transient Runnable origin;
    private final transient boolean rethrow;
    private final transient boolean verbose;

    public VerboseRunnable(Runnable runnable) {
        this(runnable, false);
    }

    public VerboseRunnable(Callable<?> callable) {
        this(callable, false);
    }

    public VerboseRunnable(Callable<?> callable, boolean swallow) {
        this(callable, swallow, true);
    }

    public VerboseRunnable(final Callable<?> callable, boolean swallow, boolean vrbs) {
        this(new Runnable(){

            @Override
            public void run() {
                try {
                    callable.call();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(ex);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }

            public String toString() {
                return callable.toString();
            }
        }, swallow, vrbs);
    }

    public VerboseRunnable(Runnable runnable, boolean swallow) {
        this(runnable, swallow, true);
    }

    public VerboseRunnable(Runnable runnable, boolean swallow, boolean vrbs) {
        this.origin = runnable;
        this.rethrow = !swallow;
        this.verbose = vrbs;
    }

    @Override
    public void run() {
        try {
            this.origin.run();
        }
        catch (RuntimeException ex) {
            if (this.rethrow) {
                Logger.warn(this, "escalated exception: %s", this.tail(ex));
                throw ex;
            }
            Logger.warn(this, "swallowed exception: %s", this.tail(ex));
        }
        catch (Error error) {
            if (this.rethrow) {
                Logger.error(this, "escalated error: %s", this.tail(error));
                throw error;
            }
            Logger.error(this, "swallowed error: %s", this.tail(error));
        }
        if (Thread.currentThread().isInterrupted()) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("the thread has been interrupted");
        }
    }

    private String tail(Throwable throwable) {
        String tail = this.verbose ? Logger.format("%[exception]s", throwable) : Logger.format("%[type]s('%s')", throwable, throwable.getMessage());
        return tail;
    }

    public String toString() {
        return "VerboseRunnable(origin=" + this.origin + ", rethrow=" + this.rethrow + ", verbose=" + this.verbose + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerboseRunnable)) {
            return false;
        }
        VerboseRunnable other = (VerboseRunnable)o;
        Runnable this$origin = this.origin;
        Runnable other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        if (this.rethrow != other.rethrow) {
            return false;
        }
        return this.verbose == other.verbose;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Runnable $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        result = result * 59 + (this.rethrow ? 79 : 97);
        result = result * 59 + (this.verbose ? 79 : 97);
        return result;
    }
}

