/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Formattable;
import java.util.Formatter;

final class FileDecor
implements Formattable {
    private final transient Object path;

    FileDecor(Object file) {
        this.path = file;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        StringWriter writer = new StringWriter();
        if (this.path == null) {
            writer.write("NULL");
        } else {
            Path self = Paths.get(this.path.toString(), new String[0]).toAbsolutePath();
            Path root = Paths.get("", new String[0]).toAbsolutePath();
            String rel = root.relativize(self).toString();
            if (rel.startsWith("..")) {
                rel = self.toString();
            }
            writer.write(rel);
        }
        formatter.format("%s", writer);
    }
}

