/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Immutable
public final class MulticolorLayout
extends PatternLayout {
    private static final String CSI = "\u001b[";
    private static final ConcurrentMap<String, String> COLORS;
    private static final ConcurrentMap<String, String> LEVELS;
    private static final Pattern METAS;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public MulticolorLayout() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    public void setConversionPattern(String pattern) {
        Matcher matcher = METAS.matcher(pattern);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, "");
            buf.append(CSI).append(this.ansi(matcher.group(1))).append('m').append(matcher.group(2)).append(CSI).append('m');
        }
        matcher.appendTail(buf);
        super.setConversionPattern(buf.toString());
    }

    public String format(LoggingEvent event) {
        return super.format(event).replace(String.format("%s?m", CSI), String.format("%s%sm", CSI, LEVELS.get(event.getLevel().toString())));
    }

    private String ansi(String meta) {
        String ansi;
        if (meta == null) {
            ansi = "?";
        } else if (meta.matches("[a-z]+")) {
            ansi = (String)COLORS.get(meta);
            if (ansi == null) {
                throw new IllegalArgumentException(String.format("unknown color '%s'", meta));
            }
        } else {
            ansi = meta;
        }
        return ansi;
    }

    public String toString() {
        return "MulticolorLayout()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MulticolorLayout)) {
            return false;
        }
        MulticolorLayout other = (MulticolorLayout)((Object)o);
        return other.canEqual((Object)this);
    }

    public boolean canEqual(Object other) {
        return other instanceof MulticolorLayout;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static {
        MulticolorLayout.ajc$preClinit();
        COLORS = new ConcurrentHashMap<String, String>(){
            private static final long serialVersionUID = 8441697854235337829L;
            {
                this.put("black", "30");
                this.put("blue", "34");
                this.put("cyan", "36");
                this.put("green", "32");
                this.put("magenta", "35");
                this.put("red", "31");
                this.put("yellow", "33");
                this.put("white", "37");
            }
        };
        LEVELS = new ConcurrentHashMap<String, String>(){
            private static final long serialVersionUID = 8441715446421374053L;
            {
                this.put(Level.TRACE.toString(), "2;33");
                this.put(Level.DEBUG.toString(), "2;37");
                this.put(Level.INFO.toString(), "0;37");
                this.put(Level.WARN.toString(), "0;33");
                this.put(Level.ERROR.toString(), "0;31");
                this.put(Level.FATAL.toString(), "0;35");
            }
        };
        METAS = Pattern.compile("%color(?:-([a-z]+|[0-9]{1,3};[0-9]{1,3};[0-9]{1,3}))?\\{(.*?)\\}");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MulticolorLayout.java", MulticolorLayout.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.log.MulticolorLayout", "", "", ""), 88);
    }
}

