/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.manifests;

import com.jcabi.log.Logger;
import com.jcabi.manifests.ClasspathMfs;
import com.jcabi.manifests.Mfs;
import com.jcabi.manifests.ServletMfs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;

public final class Manifests
extends AbstractMap<String, String> {
    private static final Manifests DEFAULT = new Manifests();
    private final transient Map<String, String> attributes;

    public Manifests() {
        this(new HashMap<String, String>(0));
    }

    public Manifests(Map<String, String> attrs) {
        this.attributes = new HashMap<String, String>(attrs);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.attributes.entrySet();
    }

    public Manifests append(Mfs streams) throws IOException {
        long start = System.currentTimeMillis();
        Collection<InputStream> list = streams.fetch();
        for (InputStream stream : list) {
            this.attributes.putAll(Manifests.load(stream));
        }
        Logger.info((Object)this, (String)"%d attributes loaded from %d stream(s) in %[ms]s: %[list]s", (Object[])new Object[]{this.attributes.size(), list.size(), System.currentTimeMillis() - start, new TreeSet<String>(this.attributes.keySet())});
        return this;
    }

    public static String read(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute can't be NULL");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("attribute can't be empty");
        }
        if (!Manifests.exists(name)) {
            throw new IllegalArgumentException(Logger.format((String)"Attribute '%s' not found in MANIFEST.MF file(s) among %d other attribute(s): %[list]s", (Object[])new Object[]{name, Manifests.DEFAULT.attributes.size(), new TreeSet<String>(Manifests.DEFAULT.attributes.keySet())}));
        }
        return (String)DEFAULT.get(name);
    }

    public static boolean exists(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute name can't be NULL");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("attribute name can't be empty");
        }
        return DEFAULT.containsKey(name);
    }

    public static void append(ServletContext ctx) throws IOException {
        DEFAULT.append(new ServletMfs(ctx));
    }

    public static void append(final File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file can't be NULL");
        }
        DEFAULT.append(new Mfs(){

            @Override
            public Collection<InputStream> fetch() throws IOException {
                return Collections.singleton(file.toURI().toURL().openStream());
            }
        });
    }

    public static void append(final InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("input stream can't be NULL");
        }
        DEFAULT.append(new Mfs(){

            @Override
            public Collection<InputStream> fetch() {
                return Collections.singleton(stream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> load(InputStream stream) throws IOException {
        ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>(0);
        try {
            Manifest manifest = new Manifest(stream);
            Attributes attrs = manifest.getMainAttributes();
            for (Object key : attrs.keySet()) {
                String value = attrs.getValue((Attributes.Name)Attributes.Name.class.cast(key));
                props.put(key.toString(), value);
            }
            Logger.debug(Manifests.class, (String)"%d attribute(s) loaded %[list]s", (Object[])new Object[]{props.size(), new TreeSet(props.keySet())});
        }
        catch (RuntimeException ex) {
            Logger.error(Manifests.class, (String)"#load(): failed %[exception]s", (Object[])new Object[]{ex});
        }
        finally {
            stream.close();
        }
        return props;
    }

    static {
        try {
            DEFAULT.append(new ClasspathMfs());
        }
        catch (IOException ex) {
            Logger.error(Manifests.class, (String)"#load(): '%s' failed %[exception]s", (Object[])new Object[]{ex});
        }
    }
}

