/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.matchers;

import com.jcabi.aspects.Immutable;
import com.jcabi.log.Logger;
import com.jcabi.w3c.Validator;
import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@Immutable
final class W3CValidatorMatcher
extends TypeSafeMatcher<String> {
    private final transient Validator validator;

    W3CValidatorMatcher(Validator val) {
        this.validator = val;
    }

    public void describeTo(Description description) {
        description.appendText("W3C validator").appendText(this.validator.toString());
    }

    public boolean matchesSafely(String content) {
        boolean matches = false;
        try {
            matches = this.validator.validate(content).valid();
        }
        catch (IOException ex) {
            Logger.warn((Object)((Object)this), (String)"#matchesSafely('%s'): unable to perform validation: %s", (Object[])new Object[]{content, ex.getMessage()});
        }
        return matches;
    }

    public String toString() {
        return "W3CValidatorMatcher(validator=" + this.validator + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof W3CValidatorMatcher)) {
            return false;
        }
        W3CValidatorMatcher other = (W3CValidatorMatcher)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Validator this$validator = this.validator;
        Validator other$validator = other.validator;
        return !(this$validator == null ? other$validator != null : !this$validator.equals(other$validator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof W3CValidatorMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Validator $validator = this.validator;
        result = result * 59 + ($validator == null ? 0 : $validator.hashCode());
        return result;
    }
}

