/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.matchers;

import com.jcabi.http.Response;
import com.jcabi.http.response.XmlResponse;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public final class NoBrokenLinks
extends BaseMatcher<Response> {
    private final transient URI home;
    private final transient Collection<URI> broken;

    public NoBrokenLinks(URI uri) {
        this.home = uri;
        this.broken = new LinkedList<URI>();
    }

    public boolean matches(Object item) {
        this.check((Response)Response.class.cast(item));
        return this.broken.isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText(Logger.format((String)"%d broken link(s) found: %[list]s", (Object[])new Object[]{this.broken.size(), this.broken}));
    }

    private void check(Response response) {
        List links = new XmlResponse(response).xml().xpath("//head/link/@href" + " | //body//a/@href" + " | //body//img/@src" + " | //xhtml:img/@src" + " | //xhtml:a/@href" + " | //xhtml:link/@href");
        Logger.debug((Object)((Object)this), (String)"#assertThat(): %d links found: %[list]s", (Object[])new Object[]{links.size(), links});
        this.broken.clear();
        for (String link : links) {
            URI uri = link.isEmpty() || link.charAt(0) != '/' ? URI.create(link) : this.home.resolve(link);
            if (uri.isAbsolute() && NoBrokenLinks.isValid(uri)) continue;
            this.broken.add(uri);
        }
    }

    private static boolean isValid(URI uri) {
        boolean valid = false;
        try {
            int code = NoBrokenLinks.http(uri.toURL());
            if (code < 400) {
                valid = true;
            } else {
                Logger.warn(NoBrokenLinks.class, (String)"#isValid('%s'): not valid since response code is %d", (Object[])new Object[]{uri, code});
            }
        }
        catch (MalformedURLException ex) {
            Logger.warn(NoBrokenLinks.class, (String)"#isValid('%s'): invalid URL: %s", (Object[])new Object[]{uri, ex.getMessage()});
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int http(URL url) {
        int code = 400;
        try {
            HttpURLConnection conn = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
            try {
                code = conn.getResponseCode();
                Logger.debug(NoBrokenLinks.class, (String)"#http('%s'): response code is %s", (Object[])new Object[]{url, code});
            }
            catch (IOException ex) {
                Logger.warn(NoBrokenLinks.class, (String)"#http('%s'): can't get response code: %s", (Object[])new Object[]{url, ex.getMessage()});
            }
            finally {
                conn.disconnect();
            }
        }
        catch (IOException ex) {
            Logger.warn(NoBrokenLinks.class, (String)"#http('%s'): can't open connection: %s", (Object[])new Object[]{url, ex.getMessage()});
        }
        return code;
    }

    public String toString() {
        return "NoBrokenLinks(home=" + this.home + ", broken=" + this.broken + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoBrokenLinks)) {
            return false;
        }
        NoBrokenLinks other = (NoBrokenLinks)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        URI this$home = this.home;
        URI other$home = other.home;
        return !(this$home == null ? other$home != null : !((Object)this$home).equals(other$home));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NoBrokenLinks;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $home = this.home;
        result = result * 59 + ($home == null ? 43 : ((Object)$home).hashCode());
        return result;
    }
}

