/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.matchers;

import com.jcabi.matchers.RegexContainingPatternMatcher;
import com.jcabi.matchers.RegexMatchingPatternMatcher;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public final class RegexMatchers {
    private RegexMatchers() {
    }

    public static Matcher<String> matchesAnyPattern(String ... patterns) {
        ArrayList<RegexMatchingPatternMatcher> matchers = new ArrayList<RegexMatchingPatternMatcher>(patterns.length);
        for (String pattern : patterns) {
            matchers.add(new RegexMatchingPatternMatcher(pattern));
        }
        return CoreMatchers.anyOf(matchers);
    }

    public static Matcher<String> matchesPattern(String pattern) {
        return new RegexMatchingPatternMatcher(pattern);
    }

    public static Matcher<String> containsPattern(String pattern) {
        return new RegexContainingPatternMatcher(pattern);
    }

    public static Matcher<String> containsAnyPattern(String ... patterns) {
        return CoreMatchers.anyOf(RegexMatchers.createContainingMatchers(patterns));
    }

    public static Matcher<String> containsAllPatterns(String ... patterns) {
        return CoreMatchers.allOf(RegexMatchers.createContainingMatchers(patterns));
    }

    private static Collection<Matcher<? super String>> createContainingMatchers(String ... patterns) {
        ArrayList<Matcher<? super String>> matchers = new ArrayList<Matcher<? super String>>(patterns.length);
        for (String pattern : patterns) {
            matchers.add((Matcher<? super String>)new RegexContainingPatternMatcher(pattern));
        }
        return matchers;
    }

    public String toString() {
        return "RegexMatchers()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof RegexMatchers;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

