/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.matchers;

import com.jcabi.matchers.XhtmlMatchers;
import com.jcabi.xml.XMLDocument;
import javax.xml.namespace.NamespaceContext;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public final class XPathMatcher<T>
extends TypeSafeMatcher<T> {
    private final transient String xpath;
    private final transient NamespaceContext context;

    public XPathMatcher(String query, NamespaceContext ctx) {
        this.xpath = query;
        this.context = ctx;
    }

    public boolean matchesSafely(T input) {
        return !new XMLDocument(XhtmlMatchers.xhtml(input)).merge(this.context).nodes(this.xpath).isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText("an XML document with XPath ").appendText(this.xpath);
    }

    public String toString() {
        return "XPathMatcher(xpath=" + this.xpath + ", context=" + this.context + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XPathMatcher)) {
            return false;
        }
        XPathMatcher other = (XPathMatcher)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$xpath = this.xpath;
        String other$xpath = other.xpath;
        return !(this$xpath == null ? other$xpath != null : !this$xpath.equals(other$xpath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XPathMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xpath = this.xpath;
        result = result * 59 + ($xpath == null ? 43 : $xpath.hashCode());
        return result;
    }
}

