/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.matchers;

import com.jcabi.xml.XMLDocument;
import java.io.StringWriter;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.w3c.dom.Node;

final class StringSource
extends DOMSource {
    private final transient String xml;

    StringSource(String text) {
        this.xml = text;
        super.setNode(new XMLDocument(text).node());
    }

    StringSource(Node node) {
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            String yes = "yes";
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (TransformerException ex) {
            throw new IllegalStateException(ex);
        }
        this.xml = writer.toString();
        this.setNode(node);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int length = this.xml.length();
        for (int pos = 0; pos < length; ++pos) {
            char chr = this.xml.charAt(pos);
            if (chr > '\u007f') {
                buf.append("&#").append(Integer.toHexString(chr).toUpperCase(Locale.ENGLISH)).append(';');
                continue;
            }
            buf.append(chr);
        }
        return buf.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringSource)) {
            return false;
        }
        StringSource other = (StringSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$xml = this.xml;
        String other$xml = other.xml;
        return !(this$xml == null ? other$xml != null : !this$xml.equals(other$xml));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringSource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xml = this.xml;
        result = result * 59 + ($xml == null ? 43 : $xml.hashCode());
        return result;
    }
}

