/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.matchers;

import com.jcabi.matchers.AllOfThatPrintsOnlyWrongMatchers;
import com.jcabi.matchers.StringSource;
import com.jcabi.matchers.XPathMatcher;
import com.jcabi.xml.XPathContext;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Scanner;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import lombok.Generated;
import org.hamcrest.Matcher;
import org.w3c.dom.Node;

public final class XhtmlMatchers {
    private XhtmlMatchers() {
    }

    public static <T> Source xhtml(T xhtml) {
        Source source;
        if (xhtml instanceof Source) {
            source = (Source)Source.class.cast(xhtml);
        } else if (xhtml instanceof InputStream) {
            InputStream stream = (InputStream)InputStream.class.cast(xhtml);
            try {
                source = new StringSource(XhtmlMatchers.readAsString(new InputStreamReader(stream, "UTF-8")));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        } else if (xhtml instanceof Reader) {
            Reader reader = (Reader)Reader.class.cast(xhtml);
            source = new StringSource(XhtmlMatchers.readAsString(reader));
        } else {
            source = xhtml instanceof Node ? new StringSource((Node)Node.class.cast(xhtml)) : new StringSource(xhtml.toString());
        }
        return source;
    }

    public static <T> Matcher<T> hasXPath(String query) {
        return XhtmlMatchers.hasXPath(query, (NamespaceContext)new XPathContext());
    }

    public static <T> Matcher<T> hasXPath(String query, Object ... namespaces) {
        return XhtmlMatchers.hasXPath(query, (NamespaceContext)new XPathContext(namespaces));
    }

    public static <T> Matcher<T> hasXPath(String query, NamespaceContext ctx) {
        return new XPathMatcher(query, ctx);
    }

    public static <T> Matcher<T> hasXPaths(String ... xpaths) {
        return XhtmlMatchers.hasXPaths(Arrays.asList(xpaths));
    }

    public static <T> Matcher<T> hasXPaths(Iterable<String> xpaths) {
        LinkedList list = new LinkedList();
        for (String xpath : xpaths) {
            list.add(XhtmlMatchers.hasXPath(xpath));
        }
        return new AllOfThatPrintsOnlyWrongMatchers(list);
    }

    private static String readAsString(Reader reader) {
        String result;
        try (Scanner scanner = new Scanner(reader).useDelimiter("\\A");){
            result = scanner.hasNext() ? scanner.next() : "";
        }
        return result;
    }

    @Generated
    public String toString() {
        return "XhtmlMatchers()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof XhtmlMatchers;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

