/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.maven.plugin;

import com.jcabi.log.Logger;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;

final class UnwovenClasses {
    private final transient File unwoven;
    private final transient File classes;
    private final transient String phase;

    UnwovenClasses(File uwvn, File cls, String phs) {
        this.unwoven = uwvn;
        this.classes = cls;
        this.phase = phs;
    }

    void copy() throws MojoFailureException {
        if ("process-classes".equals(this.phase)) {
            this.unwoven.mkdirs();
            Logger.info((Object)this, (String)"Unwoven classes will be copied to %s", (Object[])new Object[]{this.unwoven});
            UnwovenClasses.copyContents(this.classes, this.unwoven);
        } else if ("process-test-classes".equals(this.phase)) {
            String suffix = "-test";
            File tests = new File(this.unwoven.getPath().concat("-test"));
            tests.mkdirs();
            Logger.info((Object)this, (String)"Unwoven test classes will be copied to %s", (Object[])new Object[]{tests});
            UnwovenClasses.copyContents(this.classes, tests);
        }
    }

    private static void copyContents(File from, File dest) throws MojoFailureException {
        try {
            FileUtils.cleanDirectory((File)dest);
            FileUtils.copyDirectory((File)from, (File)dest, (boolean)false);
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Error when cleaning dest dir or when copying files: %s", ex.getMessage()), (Throwable)ex);
        }
    }
}

