/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.apache.maven.plugin.logging.Log;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

final class Slf4jAdapter
extends MarkerIgnoringBase {
    public static final long serialVersionUID = 1351246359409939513L;
    private final transient Log mlog;
    private final transient String label;

    Slf4jAdapter(Log log, String name) {
        this.mlog = log;
        this.label = name;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void trace(String msg) {
        this.mlog.debug((CharSequence)this.decorate(msg));
    }

    public void trace(String format, Object arg) {
        this.mlog.debug((CharSequence)this.decorate(Slf4jAdapter.format(format, arg)));
    }

    public void trace(String format, Object first, Object second) {
        this.mlog.debug((CharSequence)this.decorate(Slf4jAdapter.format(format, first, second)));
    }

    public void trace(String format, Object ... array) {
        this.mlog.debug((CharSequence)this.decorate(Slf4jAdapter.format(format, array)));
    }

    public void trace(String msg, Throwable thr) {
        this.mlog.debug((CharSequence)this.decorate(msg), thr);
    }

    public boolean isDebugEnabled() {
        return this.mlog.isDebugEnabled();
    }

    public void debug(String msg) {
        this.mlog.debug((CharSequence)this.decorate(msg));
    }

    public void debug(String format, Object arg) {
        this.mlog.debug((CharSequence)this.decorate(Slf4jAdapter.format(format, arg)));
    }

    public void debug(String format, Object first, Object second) {
        this.mlog.debug((CharSequence)this.decorate(Slf4jAdapter.format(format, first, second)));
    }

    public void debug(String format, Object ... array) {
        this.mlog.debug((CharSequence)this.decorate(Slf4jAdapter.format(format, array)));
    }

    public void debug(String msg, Throwable thr) {
        this.mlog.debug((CharSequence)this.decorate(msg), thr);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        this.mlog.info((CharSequence)msg);
    }

    public void info(String format, Object arg) {
        this.mlog.info((CharSequence)Slf4jAdapter.format(format, arg));
    }

    public void info(String format, Object first, Object second) {
        this.mlog.info((CharSequence)Slf4jAdapter.format(format, first, second));
    }

    public void info(String format, Object ... array) {
        this.mlog.info((CharSequence)Slf4jAdapter.format(format, array));
    }

    public void info(String msg, Throwable thr) {
        this.mlog.info((CharSequence)msg, thr);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.mlog.warn((CharSequence)msg);
    }

    public void warn(String format, Object arg) {
        this.mlog.warn((CharSequence)Slf4jAdapter.format(format, arg));
    }

    public void warn(String format, Object ... array) {
        this.mlog.warn((CharSequence)Slf4jAdapter.format(format, array));
    }

    public void warn(String format, Object first, Object second) {
        this.mlog.warn((CharSequence)Slf4jAdapter.format(format, first, second));
    }

    public void warn(String msg, Throwable thr) {
        this.mlog.warn((CharSequence)msg, thr);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.mlog.error((CharSequence)msg);
    }

    public void error(String format, Object arg) {
        this.mlog.error((CharSequence)Slf4jAdapter.format(format, arg));
    }

    public void error(String format, Object first, Object second) {
        this.mlog.error((CharSequence)Slf4jAdapter.format(format, first, second));
    }

    public void error(String format, Object ... array) {
        this.mlog.error((CharSequence)Slf4jAdapter.format(format, array));
    }

    public void error(String msg, Throwable thr) {
        this.mlog.error((CharSequence)msg, thr);
    }

    private static String format(String format, Object arg) {
        FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg);
        return tuple.getMessage();
    }

    private static String format(String format, Object first, Object second) {
        FormattingTuple tuple = MessageFormatter.format((String)format, (Object)first, (Object)second);
        return tuple.getMessage();
    }

    private static String format(String format, Object[] array) {
        FormattingTuple tuple = MessageFormatter.format((String)format, (Object)array);
        return tuple.getMessage();
    }

    private String decorate(String msg) {
        return String.format("%s %s: %s", Thread.currentThread().getName(), this.label, msg);
    }

    public String toString() {
        return "Slf4jAdapter(mlog=" + this.mlog + ", label=" + this.label + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Slf4jAdapter)) {
            return false;
        }
        Slf4jAdapter other = (Slf4jAdapter)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Slf4jAdapter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

