/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.mysql.maven.plugin;

import com.jcabi.aspects.Cacheable;
import com.jcabi.log.Logger;
import com.jcabi.mysql.maven.plugin.Config;
import com.jcabi.mysql.maven.plugin.Instances;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.impl.StaticLoggerBinder;

abstract class AbstractMysqlMojo
extends AbstractMojo {
    private static final String PROPERTY_REUSED = "jcabi.reused.database";
    @Parameter(defaultValue="${project}", readonly=true)
    private transient MavenProject project;
    @Parameter(defaultValue="false", required=false)
    private transient boolean skip;
    @Parameter(defaultValue="3306", required=false)
    private transient int port;
    @Parameter(defaultValue="${project.build.directory}/mysql-dist", required=true)
    private transient File dist;
    @Parameter(defaultValue="root", required=false)
    private transient String user;
    @Parameter(defaultValue="root", required=false)
    private transient String password;
    @Parameter(defaultValue="root", required=false)
    private transient String dbname;
    @Parameter(defaultValue="${project.build.directory}/mysql-data", required=true)
    private transient File data;
    @Parameter(required=false)
    private transient File socket;
    @Parameter(defaultValue="true", required=false)
    private transient boolean erase;
    @Parameter(required=false)
    private transient List<String> options;

    AbstractMysqlMojo() {
    }

    public void setSkip(boolean skp) {
        this.skip = skp;
    }

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.skip) {
            Logger.info((Object)((Object)this), (String)"execution skipped because of 'skip' option");
            return;
        }
        this.run(AbstractMysqlMojo.instances());
        if (this.project == null) {
            Logger.warn((Object)((Object)this), (String)"MavenProject not initialized, unable to set property %s", (Object[])new Object[]{PROPERTY_REUSED});
        } else {
            Logger.info((Object)((Object)this), (String)"set Maven property %s = %s ", (Object[])new Object[]{PROPERTY_REUSED, AbstractMysqlMojo.instances().reusedExistingDatabase()});
            this.project.getProperties().setProperty(PROPERTY_REUSED, Boolean.toString(AbstractMysqlMojo.instances().reusedExistingDatabase()));
        }
    }

    public File distDir() throws MojoFailureException {
        if (!this.dist.exists()) {
            throw new MojoFailureException(String.format("MySQL distribution directory doesn't exist: %s", this.dist));
        }
        return this.dist;
    }

    public File dataDir() {
        return this.data;
    }

    public File socketFile() {
        return this.socket;
    }

    public boolean clear() {
        return this.erase;
    }

    public Config config() {
        if (this.options == null) {
            this.options = Collections.emptyList();
        }
        return new Config(this.port, this.user, this.password, this.dbname, Collections.unmodifiableList(this.options));
    }

    protected abstract void run(Instances var1) throws MojoFailureException;

    @Cacheable(forever=true)
    private static Instances instances() {
        return new Instances();
    }

    public String toString() {
        return "AbstractMysqlMojo(project=" + this.project + ", skip=" + this.skip + ", port=" + this.port + ", dist=" + this.dist + ", user=" + this.user + ", password=" + this.password + ", dbname=" + this.dbname + ", data=" + this.data + ", socket=" + this.socket + ", erase=" + this.erase + ", options=" + this.options + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMysqlMojo)) {
            return false;
        }
        AbstractMysqlMojo other = (AbstractMysqlMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractMysqlMojo;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

