/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.mysql.maven.plugin;

import com.jcabi.log.Logger;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(threadSafe=true, name="classify", defaultPhase=LifecyclePhase.INITIALIZE)
public final class ClassifyMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private transient MavenProject project;
    @Parameter(defaultValue="mysql.classifier", required=true)
    private transient String classifier;
    @Parameter(required=true)
    private transient List<String> mappings;

    public void execute() throws MojoFailureException {
        String existing = this.project.getProperties().getProperty(this.classifier);
        if (existing == null) {
            String arch = this.arch();
            this.project.getProperties().setProperty(this.classifier, arch);
            Logger.info((Object)((Object)this), (String)"${%s} set to \"%s\"", (Object[])new Object[]{this.classifier, arch});
        } else if (existing.equals(this.arch())) {
            Logger.info((Object)((Object)this), (String)"${%s} already set to \"%s\"", (Object[])new Object[]{this.classifier, this.arch()});
        } else {
            throw new MojoFailureException(String.format("Maven property ${%s} already set to \"%s\", can't change to \"%s\"", this.classifier, existing, this.arch()));
        }
    }

    public void setProject(MavenProject prj) {
        this.project = prj;
    }

    public void setClassifier(String name) {
        this.classifier = name;
    }

    private String arch() throws MojoFailureException {
        if (this.mappings == null) {
            this.mappings = new LinkedList<String>();
            this.mappings.add("linux-i386 linux-x86_64");
        }
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
        String[] words = System.getProperty("os.name").split(" ");
        String value = String.format("%s-%s", words[0].toLowerCase(Locale.ENGLISH), arch);
        for (String mapping : this.mappings) {
            String[] pair = mapping.split(" ");
            if (pair.length != 2) {
                throw new MojoFailureException(String.format("Invalid mapping \"%s\" (should be \"from to\")", mapping));
            }
            if (!value.equals(pair[0])) continue;
            value = pair[1];
            Logger.info((Object)((Object)this), (String)"Architecture \"%s\" changed to \"%s\"", (Object[])new Object[]{pair[0], pair[1]});
        }
        return value;
    }

    public String toString() {
        return "ClassifyMojo(project=" + this.project + ", classifier=" + this.classifier + ", mappings=" + this.mappings + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassifyMojo)) {
            return false;
        }
        ClassifyMojo other = (ClassifyMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassifyMojo;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

