/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.mysql.maven.plugin;

import com.jcabi.aspects.Loggable;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseProcess;
import com.jcabi.log.VerboseRunnable;
import com.jcabi.mysql.maven.plugin.Config;
import com.jcabi.mysql.maven.plugin.SocketHelper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

@Loggable(value=2)
public final class Instances {
    private static final String DATA_SUB_DIR = "data";
    private static final String NO_DEFAULTS = "--no-defaults";
    private static final int RETRY_COUNT = 5;
    private static final String DEFAULT_USER = "root";
    private static final String DEFAULT_PASSWORD = "root";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private final transient ConcurrentMap<Integer, Process> processes = new ConcurrentHashMap<Integer, Process>(0);
    private transient boolean clean = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@NotNull Config config, @NotNull File dist, @NotNull File target, boolean deldir, File socket) throws IOException {
        this.setClean(target, deldir);
        ConcurrentMap<Integer, Process> concurrentMap = this.processes;
        synchronized (concurrentMap) {
            if (this.processes.containsKey(config.port())) {
                throw new IllegalArgumentException(String.format("Port %d is already busy", config.port()));
            }
            Process proc = this.process(config, dist, target, socket);
            this.processes.put(config.port(), proc);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop(config.port())));
        }
        Logger.info((Object)this, (String)"MySQL database is up and running at the %d port", (Object[])new Object[]{config.port()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int port) {
        ConcurrentMap<Integer, Process> concurrentMap = this.processes;
        synchronized (concurrentMap) {
            Process proc = (Process)this.processes.remove(port);
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    public boolean reusedExistingDatabase() {
        return !this.clean;
    }

    private Process process(@NotNull Config config, File dist, File target, File socketfile) throws IOException {
        File temp = this.prepareFolders(target);
        File socket = socketfile == null ? new File(target, "mysql.sock") : socketfile;
        ProcessBuilder builder = this.builder(dist, "bin/mysqld", NO_DEFAULTS, String.format("--user=%s", System.getProperty("user.name")), "--general_log", "--console", "--innodb_buffer_pool_size=64M", "--innodb_log_file_size=64M", "--innodb_use_native_aio=0", String.format("--binlog-ignore-db=%s", config.dbname()), String.format("--basedir=%s", dist), String.format("--lc-messages-dir=%s", new File(dist, "share")), String.format("--datadir=%s", this.data(dist, target)), String.format("--tmpdir=%s", temp), String.format("--socket=%s", socket), String.format("--log-error=%s", new File(target, "errors.log")), String.format("--general-log-file=%s", new File(target, "mysql.log")), String.format("--pid-file=%s", new File(target, "mysql.pid")), String.format("--port=%d", config.port())).redirectErrorStream(true);
        builder.environment().put("MYSQL_HOME", dist.getAbsolutePath());
        for (String option : config.options()) {
            if (StringUtils.isBlank((CharSequence)option)) continue;
            builder.command().add(String.format("--%s", option));
        }
        Process proc = builder.start();
        Thread thread = new Thread((Runnable)new VerboseRunnable(() -> {
            new VerboseProcess(proc).stdoutQuietly();
            return null;
        }));
        thread.setDaemon(true);
        thread.start();
        this.waitFor(socket, config.port());
        if (this.clean) {
            this.configure(config, dist, socket);
        }
        return proc;
    }

    private File prepareFolders(File target) throws IOException {
        File temp;
        if (this.clean && target.exists()) {
            FileUtils.deleteDirectory((File)target);
            Logger.info((Object)this, (String)"deleted %s directory", (Object[])new Object[]{target});
        }
        if (!target.exists() && target.mkdirs()) {
            Logger.info((Object)this, (String)"created %s directory", (Object[])new Object[]{target});
        }
        if (!(temp = new File(target, "temp")).exists() && !temp.mkdirs()) {
            throw new IllegalStateException("Error during temporary folder creation");
        }
        return temp;
    }

    private File data(File dist, File target) throws IOException {
        File dir = new File(target, DATA_SUB_DIR);
        if (!dir.exists()) {
            File cnf = new File(new File(dist, "share"), "my-default.cnf");
            FileUtils.writeStringToFile((File)cnf, (String)"[mysql]\n# no defaults...", (Charset)StandardCharsets.UTF_8);
            Path installer = Paths.get(dist.getAbsolutePath(), new String[0]).resolve("scripts/mysql_install_db");
            if (Files.exists(installer, new LinkOption[0])) {
                new VerboseProcess(this.builder(dist, "scripts/mysql_install_db", String.format("--defaults-file=%s", cnf), "--force", "--innodb_use_native_aio=0", String.format("--datadir=%s", dir), String.format("--basedir=%s", dist))).stdout();
            } else {
                new VerboseProcess(this.builder(dist, "bin/mysqld", "--initialize-insecure", String.format("--user=%s", "root"), String.format("--datadir=%s", dir), String.format("--basedir=%s", dist), String.format("--log-error=%s", new File(target, "errors.log")), String.format("--general-log-file=%s", new File(target, "mysql.log")))).stdout();
            }
        }
        return dir;
    }

    private File waitFor(File socket, int port) throws IOException {
        block5: {
            long start = System.currentTimeMillis();
            long age = 0L;
            do {
                if (socket.exists()) {
                    Logger.info((Object)this, (String)"Socket %s is available after %[ms]s of waiting", (Object[])new Object[]{socket, age});
                    break block5;
                }
                if (SocketHelper.isOpen(port)) {
                    Logger.info((Object)this, (String)"Port %s is available after %[ms]s of waiting", (Object[])new Object[]{port, age});
                    break block5;
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(ex);
                }
            } while ((age = System.currentTimeMillis() - start) <= TimeUnit.MINUTES.toMillis(5L));
            throw new IOException(Logger.format((String)"Socket %s is not available after %[ms]s of waiting", (Object[])new Object[]{socket, age}));
        }
        return socket;
    }

    private void configure(@NotNull Config config, File dist, File socket) throws IOException {
        new VerboseProcess(this.builder(dist, "bin/mysqladmin", NO_DEFAULTS, String.format("--wait=%d", 5), String.format("--port=%d", config.port()), String.format("--user=%s", "root"), String.format("--socket=%s", socket), String.format("--host=%s", DEFAULT_HOST), "password", "root")).stdout();
        Logger.info((Object)this, (String)"Root password '%s' set for the '%s' user", (Object[])new Object[]{"root", "root"});
        Process process = this.builder(dist, "bin/mysql", String.format("--port=%d", config.port()), String.format("--user=%s", "root"), String.format("--password=%s", "root"), String.format("--socket=%s", socket)).start();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));
        writer.print("CREATE DATABASE ");
        writer.print(config.dbname());
        writer.println(";");
        if (!"root".equals(config.user())) {
            writer.println(String.format("CREATE USER '%s'@'%s' IDENTIFIED BY '%s';", config.user(), DEFAULT_HOST, config.password()));
            writer.println(String.format("GRANT ALL ON %s.* TO '%s'@'%s';", config.dbname(), config.user(), DEFAULT_HOST));
            writer.println("SHOW DATABASES;");
        }
        writer.close();
        new VerboseProcess(process).stdout();
        Logger.info((Object)this, (String)"The '%s' user created in the '%s' database with the '%s' password", (Object[])new Object[]{config.user(), config.dbname(), config.password()});
    }

    private ProcessBuilder builder(File dist, String name, String ... cmds) {
        String label = name;
        LinkedList<String> commands = new LinkedList<String>();
        File exec = new File(dist, label);
        if (exec.exists()) {
            try {
                exec.setExecutable(true);
            }
            catch (SecurityException sex) {
                throw new IllegalStateException(sex);
            }
        } else {
            label = String.format("%s.exe", name);
            if (!new File(dist, label).exists()) {
                label = String.format("%s.pl", name);
                commands.add("perl");
            }
        }
        commands.add(new File(dist, label).getAbsolutePath());
        commands.addAll(Arrays.asList(cmds));
        Logger.info((Object)this, (String)"$ %s", (Object[])new Object[]{StringUtils.join(commands, (String)" ")});
        return new ProcessBuilder(new String[0]).command(commands.toArray(new String[0])).directory(dist);
    }

    private void setClean(File target, boolean deldir) {
        if (new File(target, DATA_SUB_DIR).exists() && !deldir) {
            Logger.info((Object)this, (String)"reuse existing database %s", (Object[])new Object[]{target});
            this.clean = false;
        } else {
            this.clean = true;
        }
        Logger.info((Object)this, (String)"reuse existing database %s", (Object[])new Object[]{!this.clean});
    }

    public String toString() {
        return "Instances(processes=" + this.processes + ", clean=" + this.clean + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instances)) {
            return false;
        }
        Instances other = (Instances)o;
        ConcurrentMap<Integer, Process> this$processes = this.processes;
        ConcurrentMap<Integer, Process> other$processes = other.processes;
        return !(this$processes == null ? other$processes != null : !this$processes.equals(other$processes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentMap<Integer, Process> $processes = this.processes;
        result = result * 59 + ($processes == null ? 43 : $processes.hashCode());
        return result;
    }
}

