/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.mysql.maven.plugin;

import com.jcabi.log.Logger;
import java.util.Locale;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(threadSafe=true, name="classify", defaultPhase=LifecyclePhase.INITIALIZE)
public final class ClassifyMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private transient MavenProject project;
    @Parameter(defaultValue="mysql.classifier", required=true, readonly=false)
    private transient String classifier;

    public void execute() throws MojoFailureException {
        String[] words = System.getProperty("os.name").split(" ");
        String value = String.format("%s-%s", words[0].toLowerCase(Locale.ENGLISH), System.getProperty("os.arch").toLowerCase(Locale.ENGLISH));
        String existing = this.project.getProperties().getProperty(this.classifier);
        if (existing == null) {
            this.project.getProperties().setProperty(this.classifier, value);
            Logger.info((Object)((Object)this), (String)"${%s} set to \"%s\"", (Object[])new Object[]{this.classifier, value});
        } else if (existing.equals(value)) {
            Logger.info((Object)((Object)this), (String)"${%s} already set to \"%s\"", (Object[])new Object[]{this.classifier, value});
        } else {
            throw new MojoFailureException(String.format("Maven property ${%s} already set to \"%s\", can't change to \"%s\"", this.classifier, existing, value));
        }
    }

    public void setProject(MavenProject prj) {
        this.project = prj;
    }

    public void setClassifier(String name) {
        this.classifier = name;
    }

    public String toString() {
        return "ClassifyMojo(project=" + this.project + ", classifier=" + this.classifier + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassifyMojo)) {
            return false;
        }
        ClassifyMojo other = (ClassifyMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassifyMojo;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

