/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.mysql.maven.plugin;

import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseProcess;
import com.jcabi.log.VerboseRunnable;
import com.jcabi.mysql.maven.plugin.Config;
import com.jcabi.mysql.maven.plugin.Instances$AjcClosure1;
import com.jcabi.mysql.maven.plugin.Instances$AjcClosure3;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@Loggable(value=2)
public final class Instances {
    private static final String NO_DEFAULTS = "--no-defaults";
    private static final String DEFAULT_USER = "root";
    private static final String DEFAULT_PASSWORD = "root";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private final transient ConcurrentMap<Integer, Process> processes = new ConcurrentHashMap<Integer, Process>(0);
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public void start(@NotNull Config config, @NotNull File dist, @NotNull File target) throws IOException {
        Config config2 = config;
        File file = dist;
        File file2 = target;
        Object[] objectArray = new Object[]{config2, file, file2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray2 = new Object[]{this, config2, file, file2, joinPoint};
            MethodLogger.aspectOf().wrapClass(new Instances$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        Instances.start_aroundBody0(this, config2, file, file2, joinPoint);
    }

    public void stop(int port) {
        int n = port;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
            MethodLogger.aspectOf().wrapClass(new Instances$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        Instances.stop_aroundBody2(this, n, joinPoint);
    }

    private Process process(@NotNull Config config, File dist, File target) throws IOException {
        Config config2 = config;
        File file = dist;
        File file2 = target;
        Object[] objectArray = new Object[]{config2, file, file2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        if (target.exists()) {
            FileUtils.deleteDirectory((File)target);
            Logger.info((Object)this, (String)"deleted %s directory", (Object[])new Object[]{target});
        }
        if (target.mkdirs()) {
            Logger.info((Object)this, (String)"created %s directory", (Object[])new Object[]{target});
        }
        if (!new File(target, "temp").mkdirs()) {
            throw new IllegalStateException("Error during temporary folder creation");
        }
        File socket = new File(target, "mysql.sock");
        ProcessBuilder builder = this.builder(dist, "bin/mysqld", NO_DEFAULTS, "--general_log", "--console", "--innodb_buffer_pool_size=64M", "--innodb_log_file_size=64M", "--log_warnings", "--innodb_use_native_aio=0", String.format("--binlog-ignore-db=%s", config.dbname()), String.format("--basedir=%s", dist), String.format("--lc-messages-dir=%s", new File(dist, "share")), String.format("--datadir=%s", this.data(dist, target)), String.format("--tmpdir=%s", new File(target, "temp")), String.format("--socket=%s", socket), String.format("--pid-file=%s", new File(target, "mysql.pid")), String.format("--port=%d", config.port())).redirectErrorStream(true);
        builder.environment().put("MYSQL_HOME", dist.getAbsolutePath());
        for (String option : config.options()) {
            if (StringUtils.isBlank((CharSequence)option)) continue;
            builder.command().add(String.format("--%s", option));
        }
        final Process proc = builder.start();
        Thread thread = new Thread((Runnable)new VerboseRunnable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                new VerboseProcess(proc).stdoutQuietly();
                return null;
            }
        }));
        thread.setDaemon(true);
        thread.start();
        this.configure(config, dist, this.waitFor(socket, config.port()));
        return proc;
    }

    private File data(File dist, File target) throws IOException {
        File dir = new File(target, "data");
        FileUtils.writeStringToFile((File)new File(dist, "support-files/my-default.cnf"), (String)"[mysql]\n# no defaults...");
        new VerboseProcess(this.builder(dist, "scripts/mysql_install_db", NO_DEFAULTS, "--force", "--innodb_use_native_aio=0", String.format("--datadir=%s", dir), String.format("--basedir=%s", dist))).stdoutQuietly();
        return dir;
    }

    private File waitFor(File socket, int port) throws IOException {
        block5: {
            long start = System.currentTimeMillis();
            long age = 0L;
            do {
                if (socket.exists()) {
                    Logger.info((Object)this, (String)"socket %s is available after %[ms]s of waiting", (Object[])new Object[]{socket, age});
                    break block5;
                }
                if (Instances.isOpen(port)) {
                    Logger.info((Object)this, (String)"port %s is available after %[ms]s of waiting", (Object[])new Object[]{port, age});
                    break block5;
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(ex);
                }
            } while ((age = System.currentTimeMillis() - start) <= TimeUnit.MINUTES.toMillis(1L));
            throw new IOException(Logger.format((String)"socket %s is not available after %[ms]s of waiting", (Object[])new Object[]{socket, age}));
        }
        return socket;
    }

    private void configure(@NotNull Config config, File dist, File socket) throws IOException {
        Config config2 = config;
        File file = dist;
        File file2 = socket;
        Object[] objectArray = new Object[]{config2, file, file2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        new VerboseProcess(this.builder(dist, "bin/mysqladmin", NO_DEFAULTS, String.format("--port=%d", config.port()), String.format("--user=%s", "root"), String.format("--socket=%s", socket), String.format("--host=%s", DEFAULT_HOST), "password", "root")).stdoutQuietly();
        Process process = this.builder(dist, "bin/mysql", String.format("--port=%d", config.port()), String.format("--user=%s", "root"), String.format("--password=%s", "root"), String.format("--socket=%s", socket)).start();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(process.getOutputStream(), "UTF-8"));
        writer.print("CREATE DATABASE ");
        writer.print(config.dbname());
        writer.println(";");
        if (!"root".equals(config.user())) {
            writer.println(String.format("CREATE USER '%s'@'%s' IDENTIFIED BY '%s';", config.user(), DEFAULT_HOST, config.password()));
            writer.println(String.format("GRANT ALL ON %s.* TO '%s'@'%s';", config.dbname(), config.user(), DEFAULT_HOST));
        }
        writer.close();
        new VerboseProcess(process).stdoutQuietly();
    }

    private ProcessBuilder builder(File dist, String name, String ... cmds) {
        String label = name;
        LinkedList<String> commands = new LinkedList<String>();
        File exec = new File(dist, label);
        if (exec.exists()) {
            try {
                exec.setExecutable(true);
            }
            catch (SecurityException sex) {
                throw new IllegalStateException(sex);
            }
        } else {
            label = String.format("%s.exe", name);
            if (!new File(dist, label).exists()) {
                label = String.format("%s.pl", name);
                commands.add("perl");
            }
        }
        commands.add(new File(dist, label).getAbsolutePath());
        commands.addAll(Arrays.asList(cmds));
        Logger.info((Object)this, (String)"$ %s", (Object[])new Object[]{StringUtils.join(commands, (String)" ")});
        return new ProcessBuilder(new String[0]).command(commands.toArray(new String[commands.size()])).directory(dist);
    }

    private static boolean isOpen(int port) {
        boolean open;
        try {
            new Socket((String)null, port);
            open = true;
        }
        catch (IOException ex) {
            open = false;
        }
        return open;
    }

    public String toString() {
        return "Instances(processes=" + this.processes + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instances)) {
            return false;
        }
        Instances other = (Instances)o;
        ConcurrentMap<Integer, Process> this$processes = this.processes;
        ConcurrentMap<Integer, Process> other$processes = other.processes;
        return !(this$processes == null ? other$processes != null : !this$processes.equals(other$processes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentMap<Integer, Process> $processes = this.processes;
        result = result * 59 + ($processes == null ? 0 : $processes.hashCode());
        return result;
    }

    static {
        Instances.ajc$preClinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void start_aroundBody0(Instances ajc$this, final Config config, File dist, File target, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        ConcurrentMap<Integer, Process> concurrentMap = ajc$this.processes;
        synchronized (concurrentMap) {
            if (ajc$this.processes.containsKey(config.port())) {
                throw new IllegalArgumentException(String.format("port %d is already busy", config.port()));
            }
            Process proc = ajc$this.process(config, dist, target);
            ajc$this.processes.put(config.port(), proc);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    Instances.this.stop(config.port());
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void stop_aroundBody2(Instances ajc$this, int port, JoinPoint joinPoint) {
        ConcurrentMap<Integer, Process> concurrentMap = ajc$this.processes;
        synchronized (concurrentMap) {
            Process proc = (Process)ajc$this.processes.remove(port);
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Instances.java", Instances.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.jcabi.mysql.maven.plugin.Instances", "com.jcabi.mysql.maven.plugin.Config:java.io.File:java.io.File", "config:dist:target", "java.io.IOException", "void"), 108);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.jcabi.mysql.maven.plugin.Instances", "int", "port", "", "void"), 134);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "process", "com.jcabi.mysql.maven.plugin.Instances", "com.jcabi.mysql.maven.plugin.Config:java.io.File:java.io.File", "config:dist:target", "java.io.IOException", "java.lang.Process"), 154);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "configure", "com.jcabi.mysql.maven.plugin.Instances", "com.jcabi.mysql.maven.plugin.Config:java.io.File:java.io.File", "config:dist:socket", "java.io.IOException", "void"), 293);
    }
}

