/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.mysql.maven.plugin;

import com.jcabi.log.Logger;
import com.jcabi.mysql.maven.plugin.AbstractMysqlMojo;
import com.jcabi.mysql.maven.plugin.Config;
import com.jcabi.mysql.maven.plugin.Instances;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(threadSafe=true, name="run", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public final class RunMojo
extends AbstractMysqlMojo {
    @Override
    public void run(Instances instances) throws MojoFailureException {
        Config config = this.config();
        try {
            instances.start(config, this.distDir(), this.dataDir());
        }
        catch (IOException ex) {
            throw new MojoFailureException("failed to start MySQL server", (Throwable)ex);
        }
        Logger.info((Object)((Object)this), (String)"MySQL is up and running on port %d", (Object[])new Object[]{config.port()});
        Logger.info((Object)((Object)this), (String)"User: %s, password: %s", (Object[])new Object[]{config.user(), config.password()});
        Logger.info((Object)((Object)this), (String)"Press Ctrl-C to stop...");
        try {
            while (true) {
                TimeUnit.MINUTES.sleep(1L);
            }
        }
        catch (InterruptedException ex) {
            throw new MojoFailureException("MySQL terminated", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return "RunMojo()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunMojo)) {
            return false;
        }
        RunMojo other = (RunMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RunMojo;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

