/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.jcabi.log.Logger;
import com.jcabi.s3.Region;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

class AwsListIterator
implements Iterator<String> {
    private final transient Region region;
    private final transient String bucket;
    private final transient String prefix;
    private transient List<String> partial;
    private transient String marker;

    public AwsListIterator(Region rgn, String bkt, String pfx) {
        this.prefix = pfx;
        this.region = rgn;
        this.bucket = bkt;
    }

    @Override
    public final boolean hasNext() {
        if (this.partial == null || this.partial.isEmpty() && this.marker != null) {
            this.partial = this.load();
        }
        return !this.partial.isEmpty();
    }

    @Override
    public final String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There are no more elements in this iterator");
        }
        return this.partial.remove(0);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    private List<String> load() {
        try {
            AmazonS3 aws = this.region.aws();
            long start = System.currentTimeMillis();
            ObjectListing listing = aws.listObjects(new ListObjectsRequest().withBucketName(this.bucket).withPrefix(this.prefix).withMarker(this.marker));
            this.marker = listing.getNextMarker();
            LinkedList<String> list = new LinkedList<String>();
            for (S3ObjectSummary sum : listing.getObjectSummaries()) {
                list.add(sum.getKey());
            }
            Logger.info((Object)this, (String)"listed %d ocket(s) with prefix '%s' in bucket '%s' in %[ms]s", (Object[])new Object[]{listing.getObjectSummaries().size(), this.prefix, this.bucket, System.currentTimeMillis() - start});
            return list;
        }
        catch (AmazonServiceException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

