/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.s3;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.s3.Bucket$Prefixed$AjcClosure1;
import com.jcabi.s3.Bucket$Prefixed$AjcClosure11;
import com.jcabi.s3.Bucket$Prefixed$AjcClosure13;
import com.jcabi.s3.Bucket$Prefixed$AjcClosure3;
import com.jcabi.s3.Bucket$Prefixed$AjcClosure5;
import com.jcabi.s3.Bucket$Prefixed$AjcClosure7;
import com.jcabi.s3.Bucket$Prefixed$AjcClosure9;
import com.jcabi.s3.Ocket;
import com.jcabi.s3.Region;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@Immutable
public interface Bucket
extends Comparable<Bucket> {
    @NotNull(message="region is never NULL")
    public Region region();

    @NotNull(message="bucket name is never NULL")
    public String name();

    @NotNull(message="ocket is never NULL")
    public Ocket ocket(@NotNull(message="S3 key can't be NULL") String var1);

    public boolean exists() throws IOException;

    public void remove(@NotNull(message="S3 key can't be NULL") String var1) throws IOException;

    public Iterable<String> list(@NotNull(message="prefix can't be NULL") String var1) throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Prefixed
    implements Bucket {
        private final transient Bucket origin;
        private final transient String prefix;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

        public Prefixed(@NotNull(message="bucket can't be NULL") Bucket bucket, @NotNull(message="prefix can't be NULL") String pfx) {
            Bucket bucket2 = bucket;
            String string = pfx;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)bucket2, (Object)string);
            MethodValidator.aspectOf().beforeCtor(joinPoint);
            Bucket bucket3 = bucket;
            String string2 = pfx;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)bucket3, (Object)string2);
            try {
                JoinPoint joinPoint3 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                try {
                }
                finally {
                    ImmutabilityChecker.aspectOf().after(joinPoint3);
                }
                this.origin = bucket;
                this.prefix = pfx;
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint2);
            }
        }

        @Override
        public Region region() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{this, joinPoint};
                return (Region)MethodLogger.aspectOf().wrapClass(new Bucket$Prefixed$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            }
            return this.origin.region();
        }

        @Override
        public String name() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{this, joinPoint};
                return (String)MethodLogger.aspectOf().wrapClass(new Bucket$Prefixed$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            }
            return this.origin.name();
        }

        @Override
        public Ocket ocket(String key) {
            String string = key;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
            if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{this, string, joinPoint};
                return (Ocket)MethodLogger.aspectOf().wrapClass(new Bucket$Prefixed$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            }
            return Prefixed.ocket_aroundBody4(this, string, joinPoint);
        }

        @Override
        public boolean exists() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
            if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{this, joinPoint};
                return Conversions.booleanValue((Object)MethodLogger.aspectOf().wrapClass(new Bucket$Prefixed$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
            }
            return this.origin.exists();
        }

        @Override
        public void remove(String key) throws IOException {
            String string = key;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
            if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{this, string, joinPoint};
                MethodLogger.aspectOf().wrapClass(new Bucket$Prefixed$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
                return;
            }
            Prefixed.remove_aroundBody8(this, string, joinPoint);
        }

        @Override
        public Iterable<String> list(String pfx) throws IOException {
            String string = pfx;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
            if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{this, string, joinPoint};
                return (Iterable)MethodLogger.aspectOf().wrapClass(new Bucket$Prefixed$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            }
            return Prefixed.list_aroundBody10(this, string, joinPoint);
        }

        @Override
        public int compareTo(Bucket bucket) {
            Bucket bucket2 = bucket;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)bucket2);
            if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{this, bucket2, joinPoint};
                return Conversions.intValue((Object)MethodLogger.aspectOf().wrapClass(new Bucket$Prefixed$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
            }
            return this.origin.compareTo(bucket2);
        }

        private String extend(String name) {
            return String.format("%s%s", this.prefix, name);
        }

        public String toString() {
            return "Bucket.Prefixed(origin=" + this.origin + ", prefix=" + this.prefix + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prefixed)) {
                return false;
            }
            Prefixed other = (Prefixed)o;
            Bucket this$origin = this.origin;
            Bucket other$origin = other.origin;
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            String this$prefix = this.prefix;
            String other$prefix = other.prefix;
            return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Bucket $origin = this.origin;
            result = result * 59 + ($origin == null ? 0 : $origin.hashCode());
            String $prefix = this.prefix;
            result = result * 59 + ($prefix == null ? 0 : $prefix.hashCode());
            return result;
        }

        static {
            Prefixed.ajc$preClinit();
        }

        static /* synthetic */ Ocket ocket_aroundBody4(Prefixed ajc$this, String key, JoinPoint joinPoint) {
            MethodValidator.aspectOf().beforeMethod(joinPoint);
            return ajc$this.origin.ocket(ajc$this.extend(key));
        }

        static /* synthetic */ void remove_aroundBody8(Prefixed ajc$this, String key, JoinPoint joinPoint) {
            MethodValidator.aspectOf().beforeMethod(joinPoint);
            ajc$this.origin.remove(ajc$this.extend(key));
        }

        static /* synthetic */ Iterable list_aroundBody10(Prefixed ajc$this, String pfx, JoinPoint joinPoint) {
            MethodValidator.aspectOf().beforeMethod(joinPoint);
            return Iterables.filter((Iterable)Iterables.transform(ajc$this.origin.list(ajc$this.extend(pfx)), (Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.substring(Prefixed.this.prefix.length());
                }
            }), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return !input.isEmpty();
                }
            });
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("Bucket.java", Prefixed.class);
            ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.s3.Bucket", "", "", ""), 154);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "region", "com.jcabi.s3.Bucket$Prefixed", "", "", "", "com.jcabi.s3.Region"), 160);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "name", "com.jcabi.s3.Bucket$Prefixed", "", "", "", "java.lang.String"), 164);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ocket", "com.jcabi.s3.Bucket$Prefixed", "java.lang.String", "key", "", "com.jcabi.s3.Ocket"), 168);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "exists", "com.jcabi.s3.Bucket$Prefixed", "", "", "java.io.IOException", "boolean"), 172);
            ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "com.jcabi.s3.Bucket$Prefixed", "java.lang.String", "key", "java.io.IOException", "void"), 176);
            ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "com.jcabi.s3.Bucket$Prefixed", "java.lang.String", "pfx", "java.io.IOException", "java.lang.Iterable"), 180);
            ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "com.jcabi.s3.Bucket$Prefixed", "com.jcabi.s3.Bucket", "bucket", "", "int"), 202);
            ajc$tjp_8 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.s3.Bucket$Prefixed", "com.jcabi.s3.Bucket:java.lang.String", "bucket:pfx", ""), 154);
            ajc$tjp_9 = factory.makeSJP("preinitialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.s3.Bucket$Prefixed", "com.jcabi.s3.Bucket:java.lang.String", "bucket:pfx", ""), 154);
        }
    }
}

