/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.aspects.RetryOnFailure;
import com.jcabi.ssh.AbstractSSHShell;
import com.jcabi.ssh.EasyRepo;
import com.jcabi.ssh.JschLogger;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class SSH
extends AbstractSSHShell {
    public static final int PORT = 22;
    private final transient String key;

    public SSH(String adr, String user, URL priv) throws IOException {
        this(adr, 22, user, priv);
    }

    public SSH(InetAddress adr, String user, URL priv) throws IOException {
        this(adr, 22, user, priv);
    }

    public SSH(String adr, String user, String priv) throws UnknownHostException {
        this(adr, 22, user, priv);
    }

    public SSH(InetAddress adr, String user, String priv) throws UnknownHostException {
        this(adr.getCanonicalHostName(), 22, user, priv);
    }

    public SSH(String adr, int prt, String user, URL priv) throws IOException {
        this(adr, prt, user, IOUtils.toString((URL)priv));
    }

    public SSH(InetAddress adr, int prt, String user, URL priv) throws IOException {
        this(adr.getCanonicalHostName(), prt, user, IOUtils.toString((URL)priv));
    }

    public SSH(String adr, int prt, String user, String priv) throws UnknownHostException {
        super(adr, prt, user);
        this.key = priv;
    }

    public static String escape(String arg) {
        return String.format("'%s'", arg.replace("'", "'\\''"));
    }

    @Override
    @RetryOnFailure(attempts=7, delay=1L, unit=TimeUnit.MINUTES, verbose=false, randomize=true, types={IOException.class})
    protected Session session() throws IOException {
        try {
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            JSch.setLogger((Logger)new JschLogger());
            JSch jsch = new JSch();
            File file = File.createTempFile("jcabi-ssh", ".key");
            FileUtils.forceDeleteOnExit((File)file);
            FileUtils.write((File)file, (CharSequence)this.key.replaceAll("\r", "").replaceAll("\n\\s+|\n{2,}", "\n").trim(), (String)"UTF-8");
            jsch.setHostKeyRepository((HostKeyRepository)new EasyRepo());
            jsch.addIdentity(file.getAbsolutePath());
            com.jcabi.log.Logger.debug((Object)this, (String)"Opening SSH session to %s@%s:%s (%d bytes in RSA key)...", (Object[])new Object[]{this.getLogin(), this.getAddr(), this.getPort(), file.length()});
            Session session = jsch.getSession(this.getLogin(), this.getAddr(), this.getPort());
            session.setServerAliveInterval((int)TimeUnit.SECONDS.toMillis(10L));
            session.setServerAliveCountMax(1000000);
            session.connect();
            FileUtils.deleteQuietly((File)file);
            return session;
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public String toString() {
        return "SSH(key=" + this.key + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSH)) {
            return false;
        }
        SSH other = (SSH)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SSH;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $key = this.key;
        result = result * 59 + ($key == null ? 0 : $key.hashCode());
        return result;
    }
}

