/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.log.VerboseProcess;
import com.jcabi.ssh.Shell;
import com.jcabi.ssh.Ssh;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.cactoos.Input;
import org.cactoos.io.LengthOf;
import org.cactoos.io.ResourceOf;
import org.cactoos.io.TeeInput;
import org.cactoos.text.TextOf;

public final class Sshd
implements Closeable {
    private final transient File dir;
    private final transient Process process;
    private final transient int prt;

    public Sshd() throws IOException {
        this(new File(System.getProperty("java.io.tmpdir")));
    }

    public Sshd(File path) throws IOException {
        this.dir = path;
        File rsa = new File(this.dir, "host_rsa_key");
        new LengthOf((Input)new TeeInput((Input)new ResourceOf((CharSequence)"com/jcabi/ssh/ssh_host_rsa_key"), rsa)).value();
        File keys = new File(this.dir, "authorized");
        new LengthOf((Input)new TeeInput((Input)new ResourceOf((CharSequence)"com/jcabi/ssh/authorized_keys"), keys)).value();
        new VerboseProcess(new ProcessBuilder(new String[0]).command("chmod", "600", keys.getAbsolutePath(), rsa.getAbsolutePath())).stdout();
        this.prt = Sshd.reserve();
        this.process = new ProcessBuilder(new String[0]).command("/usr/sbin/sshd", "-p", Integer.toString(this.prt), "-h", rsa.getAbsolutePath(), "-D", "-e", "-o", String.format("PidFile=%s", new File(this.dir, "pid")), "-o", "UsePAM=no", "-o", String.format("AuthorizedKeysFile=%s", keys), "-o", "StrictModes=no").start();
        new Thread(() -> new VerboseProcess(this.process).stdout()).start();
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void close() {
        this.process.destroy();
    }

    public File home() {
        return this.dir;
    }

    public static String login() {
        return new VerboseProcess(new ProcessBuilder(new String[0]).command("id", "-n", "-u")).stdout().trim();
    }

    public static String host() {
        return new VerboseProcess(new ProcessBuilder(new String[0]).command("hostname")).stdout().trim();
    }

    public int port() {
        return this.prt;
    }

    public static String key() throws IOException {
        return new TextOf((Input)new ResourceOf((CharSequence)"com/jcabi/ssh/id_rsa")).asString();
    }

    public Shell connect() throws IOException {
        return new Ssh(Sshd.host(), this.port(), Sshd.login(), Sshd.key());
    }

    private static int reserve() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }
}

