/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssl.maven.plugin;

import com.jcabi.log.Logger;
import com.jcabi.ssl.maven.plugin.Cacerts;
import com.jcabi.ssl.maven.plugin.Keystore;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.slf4j.impl.StaticLoggerBinder;

@MojoGoal(value="keygen")
@MojoPhase(value="initialize")
public final class KeygenMojo
extends AbstractMojo {
    @MojoParameter(expression="${project}", required=true, readonly=true, description="Maven project")
    private transient MavenProject project;
    @MojoParameter(defaultValue="false", required=false, description="Skips execution")
    private transient boolean skip;
    @MojoParameter(defaultValue="${project.build.directory}/keystore.jks", required=false, description="Name of keystore.jks file")
    private transient File keystore;
    @MojoParameter(defaultValue="${project.build.directory}/cacerts.jks", required=false, description="Name of cacerts.jks file")
    private transient File cacerts;
    private transient Keystore store;
    private transient Cacerts truststore;

    public KeygenMojo() {
        this(null, new Keystore(DigestUtils.md5Hex((String)KeygenMojo.class.getName())), null);
    }

    public KeygenMojo(MavenProject prj, Keystore str, Cacerts crt) {
        this.project = prj;
        this.store = str;
        this.truststore = crt;
    }

    public void setSkip(boolean skp) {
        this.skip = skp;
    }

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.skip) {
            Logger.info((Object)((Object)this), (String)"execution skipped because of 'skip' option");
            return;
        }
        try {
            if (this.truststore == null) {
                this.truststore = new Cacerts(this.cacerts);
            }
            if (!this.store.isActive()) {
                this.store.activate(this.keystore);
                this.truststore.imprt();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.store.populate(this.project.getProperties());
        this.truststore.populate(this.project.getProperties());
        Logger.info((Object)((Object)this), (String)"Keystore is active: %s", (Object[])new Object[]{this.store});
    }
}

