/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssl.maven.plugin;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.log.Logger;
import com.jcabi.ssl.maven.plugin.Cacerts$AjcClosure1;
import com.jcabi.ssl.maven.plugin.Keytool;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Immutable
final class Cacerts {
    public static final String TRUST = "javax.net.ssl.trustStore";
    public static final String TRUST_PWD = "javax.net.ssl.trustStorePassword";
    public static final String STD_PWD = "changeit";
    private final transient String store;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public Cacerts(@NotNull File file) throws IOException {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)file2);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        File file3 = file;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)file3);
        try {
            this.store = file.getAbsolutePath();
            File prev = new File(String.format("%s/lib/security/cacerts", System.getProperty("java.home")));
            FileUtils.copyFile((File)prev, (File)file);
            Logger.info((Object)this, (String)"Existing cacerts '%s' copied to '%s' (%s)", (Object[])new Object[]{prev, this.store, FileUtils.byteCountToDisplaySize((long)this.store.length())});
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint2);
        }
    }

    public void imprt() throws IOException {
        File keystore = new File(System.getProperty("javax.net.ssl.keyStore"));
        String pwd = System.getProperty("javax.net.ssl.keyStorePassword");
        new Keytool(new File(this.store), STD_PWD).imprt(keystore, pwd);
        System.setProperty(TRUST, this.store);
        System.setProperty(TRUST_PWD, STD_PWD);
        Logger.info((Object)this, (String)"keyStore '%s' imported into trustStore '%s'", (Object[])new Object[]{keystore, this.store});
    }

    @Loggable(value=1)
    public void populate(Properties props) {
        Properties properties = props;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)properties);
        Object[] objectArray = new Object[]{this, properties, joinPoint};
        Cacerts$AjcClosure1 cacerts$AjcClosure1 = new Cacerts$AjcClosure1(objectArray);
        MethodLogger.aspectOf().wrapMethod(cacerts$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public String toString() {
        return "Cacerts(store=" + this.store + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cacerts)) {
            return false;
        }
        Cacerts other = (Cacerts)o;
        String this$store = this.store;
        String other$store = other.store;
        return !(this$store == null ? other$store != null : !this$store.equals(other$store));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $store = this.store;
        result = result * 59 + ($store == null ? 43 : $store.hashCode());
        return result;
    }

    static {
        Cacerts.ajc$preClinit();
    }

    static /* synthetic */ void populate_aroundBody0(Cacerts ajc$this, Properties props, JoinPoint joinPoint) {
        String[] names;
        for (String name : names = new String[]{TRUST, TRUST_PWD}) {
            String value = System.getProperty(name);
            if (value == null) continue;
            props.put(name, value);
            Logger.info((Object)ajc$this, (String)"Maven property ${%s} set to '%s'", (Object[])new Object[]{name, value});
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Cacerts.java", Cacerts.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "populate", "com.jcabi.ssl.maven.plugin.Cacerts", "java.util.Properties", "props", "", "void"), 123);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.ssl.maven.plugin.Cacerts", "java.io.File", "file", "java.io.IOException"), 81);
        ajc$tjp_2 = factory.makeSJP("preinitialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.ssl.maven.plugin.Cacerts", "java.io.File", "file", "java.io.IOException"), 80);
    }
}

