/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.urn;

import com.jcabi.aspects.Immutable;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

@Immutable
public final class URN
implements Comparable<URN>,
Serializable {
    private static final long serialVersionUID = -4663847066574608673L;
    private static final String ENCODING = "UTF-8";
    private static final String EMPTY = "void";
    private static final String PREFIX = "urn";
    private static final String SEP = ":";
    private static final String REGEX = "^(?i)^urn(?-i):[a-z]{1,31}(:([\\-a-zA-Z0-9/]|%[0-9a-fA-F]{2})*)+(\\?\\w+(=([\\-a-zA-Z0-9/]|%[0-9a-fA-F]{2})*)?(&\\w+(=([\\-a-zA-Z0-9/]|%[0-9a-fA-F]{2})*)?)*)?\\*?$";
    private final String uri;

    public URN() {
        this(EMPTY, "");
    }

    public URN(String text) throws URISyntaxException {
        if (text == null) {
            throw new IllegalArgumentException("text can't be NULL");
        }
        if (!text.matches(REGEX)) {
            throw new URISyntaxException(text, "Invalid format of URN");
        }
        this.uri = text;
        this.validate();
    }

    public URN(String nid, String nss) {
        if (nid == null) {
            throw new IllegalArgumentException("NID can't be NULL");
        }
        if (nss == null) {
            throw new IllegalArgumentException("NSS can't be NULL");
        }
        this.uri = String.format("%s%s%s%2$s%s", PREFIX, SEP, nid, URN.encode(nss));
        try {
            this.validate();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static URN create(String text) {
        if (text == null) {
            throw new IllegalArgumentException("URN can't be NULL");
        }
        try {
            return new URN(text);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String toString() {
        return this.uri;
    }

    @Override
    public int compareTo(URN urn) {
        return this.uri.compareTo(urn.uri);
    }

    public static boolean isValid(String text) {
        boolean valid = true;
        try {
            new URN(text);
        }
        catch (URISyntaxException ex) {
            valid = false;
        }
        return valid;
    }

    public boolean matches(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can't be NULL");
        }
        boolean matches = false;
        if (this.toString().equals(pattern)) {
            matches = true;
        } else if (pattern.endsWith("*")) {
            String body = pattern.substring(0, pattern.length() - 1);
            matches = this.uri.startsWith(body);
        }
        return matches;
    }

    public boolean isEmpty() {
        return EMPTY.equals(this.nid());
    }

    public URI toURI() {
        return URI.create(this.uri);
    }

    public String nid() {
        return this.segment(1);
    }

    public String nss() {
        try {
            return URLDecoder.decode(this.segment(2), ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Map<String, String> params() {
        return URN.demap(this.toString());
    }

    public String param(String name) {
        if (name == null) {
            throw new IllegalArgumentException("param name can't be NULL");
        }
        Map<String, String> params = this.params();
        if (!params.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Param '%s' not found in '%s', among %s", name, this, params.keySet()));
        }
        return params.get(name);
    }

    public URN param(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("param can't be NULL");
        }
        if (value == null) {
            throw new IllegalArgumentException("param value can't be NULL");
        }
        Map<String, String> params = this.params();
        params.put(name, value.toString());
        return URN.create(String.format("%s%s", StringUtils.split((String)this.toString(), (char)'?')[0], URN.enmap(params)));
    }

    public URN pure() {
        String urn = this.toString();
        if (this.hasParams()) {
            urn = urn.substring(0, urn.indexOf(63));
        }
        return URN.create(urn);
    }

    public boolean hasParams() {
        return this.toString().contains("?");
    }

    private String segment(int pos) {
        return StringUtils.splitPreserveAllTokens((String)this.uri, (String)SEP, (int)3)[pos];
    }

    private void validate() throws URISyntaxException {
        if (this.isEmpty() && !this.nss().isEmpty()) {
            throw new URISyntaxException(this.toString(), "Empty URN can't have NSS");
        }
        String nid = this.nid();
        if (!nid.matches("^[a-z]{1,31}$")) {
            throw new IllegalArgumentException(String.format("NID '%s' can contain up to 31 low case letters", this.nid()));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)PREFIX, (CharSequence)nid)) {
            throw new IllegalArgumentException("NID can't be 'urn' according to RFC 2141, section 2.1");
        }
    }

    private static Map<String, String> demap(String urn) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] sectors = StringUtils.split((String)urn, (char)'?');
        if (sectors.length == 2) {
            String[] parts;
            for (String part : parts = StringUtils.split((String)sectors[1], (char)'&')) {
                String value;
                String[] pair = StringUtils.split((String)part, (char)'=');
                if (pair.length == 2) {
                    try {
                        value = URLDecoder.decode(pair[1], ENCODING);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new IllegalStateException(ex);
                    }
                } else {
                    value = "";
                }
                map.put(pair[0], value);
            }
        }
        return map;
    }

    private static String enmap(Map<String, String> params) {
        StringBuilder query = new StringBuilder(100);
        if (!params.isEmpty()) {
            query.append('?');
            boolean first = true;
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (!first) {
                    query.append('&');
                }
                query.append(param.getKey());
                if (!param.getValue().isEmpty()) {
                    query.append('=').append(URN.encode(param.getValue()));
                }
                first = false;
            }
        }
        return query.toString();
    }

    private static String encode(String text) {
        byte[] bytes;
        try {
            bytes = text.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        StringBuilder encoded = new StringBuilder(100);
        for (byte chr : bytes) {
            if (URN.allowed(chr)) {
                encoded.append((char)chr);
                continue;
            }
            encoded.append('%').append(String.format("%X", chr));
        }
        return encoded.toString();
    }

    private static boolean allowed(byte chr) {
        return chr >= 65 && chr <= 90 || chr >= 48 && chr <= 57 || chr >= 97 && chr <= 122 || chr == 47 || chr == 45;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URN)) {
            return false;
        }
        URN other = (URN)o;
        String this$uri = this.uri;
        String other$uri = other.uri;
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.uri;
        result = result * 59 + ($uri == null ? 0 : $uri.hashCode());
        return result;
    }
}

