/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.w3c;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.request.JdkRequest;
import com.jcabi.http.response.XmlResponse;
import com.jcabi.log.Logger;
import com.jcabi.w3c.AbstractBaseValidator;
import com.jcabi.w3c.DefaultValidationResponse;
import com.jcabi.w3c.Defect;
import com.jcabi.w3c.ValidationResponse;
import com.jcabi.w3c.Validator;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;

@Immutable
final class DefaultCssValidator
extends AbstractBaseValidator
implements Validator {
    private final transient String uri;

    DefaultCssValidator(URI entry) {
        this.uri = entry.toString();
    }

    @Override
    public ValidationResponse validate(String css) throws IOException {
        ValidationResponse response;
        Pattern pattern = Pattern.compile(".*^/\\* JIGSAW IGNORE: [^\\n]+\\*/$.*", 40);
        try {
            response = pattern.matcher(css).matches() ? AbstractBaseValidator.success("") : this.processed(css);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException(ex);
        }
        return response;
    }

    private ValidationResponse processed(String css) throws IOException {
        Request req = this.request(AbstractBaseValidator.entity("file", DefaultCssValidator.filter(css), "text/css"));
        Response response = DefaultCssValidator.correct(req.fetch());
        return DefaultCssValidator.build(((XmlResponse)response.as(XmlResponse.class)).registerNs("env", "http://www.w3.org/2003/05/soap-envelope").registerNs("m", "http://www.w3.org/2005/07/css-validator").assertXPath("//m:validity").assertXPath("//m:checkedby").xml());
    }

    private Request request(String entity) {
        return new JdkRequest(this.uri).method("POST").body().set(entity).back().header("User-Agent", (Object)AbstractBaseValidator.USER_AGENT).header("Accept", (Object)"application/soap+xml").header("Content-Type", (Object)Logger.format((String)"%s; boundary=%s", (Object[])new Object[]{"multipart/form-data", "vV9olNqRj00PC4OIlM7"}));
    }

    private static ValidationResponse build(XML soap) {
        DefaultValidationResponse resp = new DefaultValidationResponse("true".equals(AbstractBaseValidator.textOf(soap.xpath("//m:validity/text()"))), UriBuilder.fromUri((String)AbstractBaseValidator.textOf(soap.xpath("//m:checkedby/text()"))).build(new Object[0]), AbstractBaseValidator.textOf(soap.xpath("//m:doctype/text()")), AbstractBaseValidator.charset(AbstractBaseValidator.textOf(soap.xpath("//m:charset/text()"))));
        for (XML node : soap.nodes("//m:error")) {
            resp.addError(DefaultCssValidator.defect(node));
        }
        for (XML node : soap.nodes("//m:warning")) {
            resp.addWarning(DefaultCssValidator.defect(node));
        }
        return resp;
    }

    private static Defect defect(XML node) {
        return new Defect(AbstractBaseValidator.intOf(node.xpath("m:line/text()")), AbstractBaseValidator.intOf(node.xpath("m:col/text()")), AbstractBaseValidator.textOf(node.xpath("m:source/text()")), AbstractBaseValidator.textOf(node.xpath("m:explanation/text()")), AbstractBaseValidator.textOf(node.xpath("m:messageid/text()")), AbstractBaseValidator.textOf(node.xpath("m:message/text()")));
    }

    private static Response correct(Response response) throws IOException {
        List<Integer> statuses = Arrays.asList(500, 501, 502, 503, 504, 505);
        if (statuses.contains(response.status())) {
            throw new IOException(String.format("Bad status from W3C server: %1d", response.status()));
        }
        return response;
    }

    private static String filter(String css) {
        return Pattern.compile("^/\\* JIGSAW: [^\\n]+\\*/$", 40).matcher(css).replaceAll("");
    }

    @Override
    public String toString() {
        return "DefaultCssValidator(uri=" + this.uri + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultCssValidator)) {
            return false;
        }
        DefaultCssValidator other = (DefaultCssValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.uri;
        String other$uri = other.uri;
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultCssValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.uri;
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        return result;
    }
}

