/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.w3c;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.request.JdkRequest;
import com.jcabi.http.response.XmlResponse;
import com.jcabi.log.Logger;
import com.jcabi.w3c.AbstractBaseValidator;
import com.jcabi.w3c.DefaultValidationResponse;
import com.jcabi.w3c.Defect;
import com.jcabi.w3c.ValidationResponse;
import com.jcabi.w3c.Validator;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Immutable
final class DefaultHtmlValidator
extends AbstractBaseValidator
implements Validator {
    private final transient String uri;

    DefaultHtmlValidator(URI entry) {
        this.uri = entry.toString();
    }

    @Override
    public ValidationResponse validate(String html) throws IOException {
        Request req = this.request(html);
        Response response = req.fetch();
        if (response.status() != 200) {
            throw new IOException(response.reason());
        }
        return this.build(((XmlResponse)response.as(XmlResponse.class)).registerNs("nu", "http://n.validator.nu/messages/").assertXPath("//nu:messages").assertXPath("//nu:source").xml());
    }

    private Request request(String entity) {
        return new JdkRequest(this.uri).method("POST").body().set(entity).back().header("User-Agent", (Object)AbstractBaseValidator.USER_AGENT).header("Accept", (Object)"text/html").header("Content-Type", (Object)Logger.format((String)"%s; charset=%s", (Object[])new Object[]{"text/html", StandardCharsets.UTF_8}));
    }

    private ValidationResponse build(XML xml) {
        List errors = xml.nodes("//nu:error");
        List warnings = xml.nodes("//nu:info");
        DefaultValidationResponse resp = new DefaultValidationResponse(errors.isEmpty() && warnings.isEmpty(), URI.create(this.uri), AbstractBaseValidator.textOf(xml.xpath("//nu:source/@type")), AbstractBaseValidator.charset(AbstractBaseValidator.textOf(xml.xpath("//nu:source/@encoding"))));
        for (XML node : errors) {
            resp.addError(DefaultHtmlValidator.defect(node));
        }
        for (XML node : warnings) {
            resp.addWarning(DefaultHtmlValidator.defect(node));
        }
        return resp;
    }

    private static Defect defect(XML node) {
        return new Defect(AbstractBaseValidator.intOf(node.xpath("nu:error/@last-line")), AbstractBaseValidator.intOf(node.xpath("nu:error/@last-column")), AbstractBaseValidator.textOf(node.xpath("nu:extract/text()")), AbstractBaseValidator.textOf(node.xpath("nu:elaboration/text()")), "", AbstractBaseValidator.textOf(node.xpath("nu:message/text()")));
    }

    @Override
    public String toString() {
        return "DefaultHtmlValidator(uri=" + this.uri + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultHtmlValidator)) {
            return false;
        }
        DefaultHtmlValidator other = (DefaultHtmlValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.uri;
        String other$uri = other.uri;
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultHtmlValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.uri;
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        return result;
    }
}

