/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.w3c;

import com.jcabi.log.Logger;
import com.jcabi.w3c.Defect;
import com.jcabi.w3c.ValidationResponse;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

final class DefaultValidationResponse
implements ValidationResponse {
    private final transient boolean ivalid;
    private final transient URI validator;
    private final transient String type;
    private final transient Charset encoding;
    private final transient Set<Defect> ierrors;
    private final transient Set<Defect> iwarnings;

    DefaultValidationResponse(boolean val, URI server, String tpe, Charset enc) {
        this.ivalid = val;
        this.validator = server;
        this.type = tpe;
        this.encoding = enc;
        this.ierrors = new CopyOnWriteArraySet<Defect>();
        this.iwarnings = new CopyOnWriteArraySet<Defect>();
    }

    public String toString() {
        return new StringBuilder(0).append(Logger.format((String)"Validity: %B\n", (Object[])new Object[]{this.ivalid})).append(Logger.format((String)"Validator: \"%s\"\n", (Object[])new Object[]{this.validator})).append(Logger.format((String)"DOCTYPE: \"%s\"\n", (Object[])new Object[]{this.type})).append(Logger.format((String)"Charset: \"%s\"\n", (Object[])new Object[]{this.encoding})).append("Errors:\n").append(DefaultValidationResponse.asText(this.ierrors)).append("Warnings:\n").append(DefaultValidationResponse.asText(this.iwarnings)).toString();
    }

    @Override
    public boolean valid() {
        return this.ivalid;
    }

    @Override
    public URI checkedBy() {
        return this.validator;
    }

    @Override
    public String doctype() {
        return this.type;
    }

    @Override
    public Charset charset() {
        return this.encoding;
    }

    @Override
    public Set<Defect> errors() {
        return Collections.unmodifiableSet(this.ierrors);
    }

    @Override
    public Set<Defect> warnings() {
        return Collections.unmodifiableSet(this.iwarnings);
    }

    public void addError(Defect error) {
        this.ierrors.add(error);
    }

    public void addWarning(Defect warning) {
        this.iwarnings.add(warning);
    }

    private static String asText(Set<Defect> defects) {
        StringBuilder text = new StringBuilder(0);
        for (Defect defect : defects) {
            text.append("  ").append(defect.toString()).append('\n');
        }
        return text.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultValidationResponse)) {
            return false;
        }
        DefaultValidationResponse other = (DefaultValidationResponse)o;
        if (this.ivalid != other.ivalid) {
            return false;
        }
        URI this$validator = this.validator;
        URI other$validator = other.validator;
        if (this$validator == null ? other$validator != null : !((Object)this$validator).equals(other$validator)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Charset this$encoding = this.encoding;
        Charset other$encoding = other.encoding;
        if (this$encoding == null ? other$encoding != null : !((Object)this$encoding).equals(other$encoding)) {
            return false;
        }
        Set<Defect> this$ierrors = this.ierrors;
        Set<Defect> other$ierrors = other.ierrors;
        if (this$ierrors == null ? other$ierrors != null : !((Object)this$ierrors).equals(other$ierrors)) {
            return false;
        }
        Set<Defect> this$iwarnings = this.iwarnings;
        Set<Defect> other$iwarnings = other.iwarnings;
        return !(this$iwarnings == null ? other$iwarnings != null : !((Object)this$iwarnings).equals(other$iwarnings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ivalid ? 79 : 97);
        URI $validator = this.validator;
        result = result * 59 + ($validator == null ? 43 : ((Object)$validator).hashCode());
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Charset $encoding = this.encoding;
        result = result * 59 + ($encoding == null ? 43 : ((Object)$encoding).hashCode());
        Set<Defect> $ierrors = this.ierrors;
        result = result * 59 + ($ierrors == null ? 43 : ((Object)$ierrors).hashCode());
        Set<Defect> $iwarnings = this.iwarnings;
        result = result * 59 + ($iwarnings == null ? 43 : ((Object)$iwarnings).hashCode());
        return result;
    }
}

