/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import com.jcabi.xml.XMLDocument;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Node;

final class ListWrapper<T>
implements List<T> {
    private final transient List<T> original;
    private final transient Node dom;
    private final transient String xpath;

    ListWrapper(List<T> list, Node node, String addr) {
        this.original = list;
        this.dom = node;
        this.xpath = addr;
    }

    public String toString() {
        return this.original.toString();
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("#add(T)");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("#add(int, T)");
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("#addAll(Collection)");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> elms) {
        throw new UnsupportedOperationException("#add(int, Collection)");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("#clear()");
    }

    @Override
    public boolean contains(Object element) {
        return this.original.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        return this.original.containsAll(elements);
    }

    @Override
    public T get(int index) {
        if (index >= this.size()) {
            throw new NodeNotFoundException(String.format("Index (%d) is out of bounds (size=%d)", index, this.size()), this.dom, this.xpath);
        }
        return this.original.get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.original.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.original.iterator();
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.original.lastIndexOf(element);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.original.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.original.listIterator(index);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("#remove(int)");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("#remove(Object)");
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        throw new UnsupportedOperationException("#removeAll(Collection)");
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        throw new UnsupportedOperationException("#retainAll(Collection)");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("#set(int, T)");
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public List<T> subList(int start, int end) {
        if (start >= this.size()) {
            throw new NodeNotFoundException(String.format("Start of subList (%d) is out of bounds (size=%d)", start, this.size()), this.dom, this.xpath);
        }
        if (end >= this.size()) {
            throw new NodeNotFoundException(String.format("End of subList (%d) is out of bounds (size=%d)", end, this.size()), this.dom, this.xpath);
        }
        return this.original.subList(start, end);
    }

    @Override
    public Object[] toArray() {
        return this.original.toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.original.toArray(array);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListWrapper)) {
            return false;
        }
        ListWrapper other = (ListWrapper)o;
        List<T> this$original = this.original;
        List<T> other$original = other.original;
        if (this$original == null ? other$original != null : !((Object)this$original).equals(other$original)) {
            return false;
        }
        Node this$dom = this.dom;
        Node other$dom = other.dom;
        if (this$dom == null ? other$dom != null : !this$dom.equals(other$dom)) {
            return false;
        }
        String this$xpath = this.xpath;
        String other$xpath = other.xpath;
        return !(this$xpath == null ? other$xpath != null : !this$xpath.equals(other$xpath));
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $original = this.original;
        result = result * 59 + ($original == null ? 0 : ((Object)$original).hashCode());
        Node $dom = this.dom;
        result = result * 59 + ($dom == null ? 0 : $dom.hashCode());
        String $xpath = this.xpath;
        result = result * 59 + ($xpath == null ? 0 : $xpath.hashCode());
        return result;
    }

    private static final class NodeNotFoundException
    extends IndexOutOfBoundsException {
        private static final long serialVersionUID = 8441709948862907504L;

        NodeNotFoundException(String message, Node node, CharSequence query) {
            super(Logger.format((String)"XPath '%s' not found in '%[text]s': %s", (Object[])new Object[]{NodeNotFoundException.escapeUnicode(query), NodeNotFoundException.escapeUnicode(new XMLDocument(node).toString()), message}));
        }

        private static String escapeUnicode(CharSequence input) {
            int length = input.length();
            StringBuilder output = new StringBuilder(length);
            for (int index = 0; index < length; ++index) {
                char character = input.charAt(index);
                if (character < ' ' || character > '\u007f') {
                    output.append(String.format("\\u%X", character));
                    continue;
                }
                output.append(character);
            }
            return output.toString();
        }
    }
}

