/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.ls.LSInput;

class ClasspathInput
implements LSInput {
    private transient String publicid;
    private transient String systemid;

    ClasspathInput(String pubid, String sysid) {
        this.publicid = pubid;
        this.systemid = sysid;
    }

    @Override
    public String getPublicId() {
        return this.publicid;
    }

    @Override
    public void setPublicId(String pubid) {
        this.publicid = pubid;
    }

    @Override
    public String getSystemId() {
        return this.systemid;
    }

    @Override
    public void setSystemId(String sysid) {
        this.systemid = sysid;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public InputStream getByteStream() {
        return null;
    }

    @Override
    public boolean getCertifiedText() {
        return false;
    }

    @Override
    public Reader getCharacterStream() {
        return null;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getStringData() {
        InputStream stream = this.getClass().getResourceAsStream(this.systemid);
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Systemid %s resource does not exist or can't be opened.", this.systemid));
        }
        try {
            String string = IOUtils.toString((InputStream)stream, (Charset)Charset.forName("UTF-8"));
            return string;
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(String.format("Unable to read input stream of systemid %s", this.systemid), exception);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Override
    public void setBaseURI(String baseuri) {
    }

    @Override
    public void setByteStream(InputStream bytestream) {
    }

    @Override
    public void setCertifiedText(boolean certifiedtext) {
    }

    @Override
    public void setCharacterStream(Reader characterstream) {
    }

    @Override
    public void setEncoding(String encoding) {
    }

    @Override
    public void setStringData(String stringdata) {
    }
}

